CREATE TABLE `#__ak_acl` (   `user_id` bigint(20) unsigned NOT NULL,   `permissions` mediumtext,   PRIMARY KEY (`user_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `configuration` longtext,   `filters` longtext,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_profiles` VALUES ('1', 'Default Backup Profile', '###AES128###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', '');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) NOT NULL,   `comment` longtext,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',   `origin` varchar(30) NOT NULL DEFAULT 'backend',   `type` varchar(30) NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext,   `absolute_path` longtext,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__ak_stats` VALUES ('1', 'Respaldo tomado en Viernes, 24 Febrero 2012 20:38', '', '2012-02-24 20:38:59', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-www.fmradioamiga.com.ar-20120224-203859.zip', '/home/fmradio/public_html/administrator/components/com_akeeba/backup/site-www.fmradioamiga.com.ar-20120224-203859.zip', '0', 'backend', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext,   PRIMARY KEY (`tag`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__banner` (   `bid` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` varchar(30) NOT NULL DEFAULT 'banner',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `imageurl` varchar(100) NOT NULL DEFAULT '',   `clickurl` varchar(200) NOT NULL DEFAULT '',   `date` datetime DEFAULT NULL,   `showBanner` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` tinyint(1) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `editor` varchar(50) DEFAULT NULL,   `custombannercode` text,   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `tags` text NOT NULL,   `params` text NOT NULL,   PRIMARY KEY (`bid`),   KEY `viewbanner` (`showBanner`),   KEY `idx_banner_catid` (`catid`) ) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `#__banner` VALUES ('1', '1', 'banner', 'OSM 1', 'osm-1', '0', '43', '0', 'osmbanner1.png', 'http://www.opensourcematters.org', '2004-07-07 15:31:29', '1', '0', '0000-00-00 00:00:00', '', '', '13', '', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('2', '1', 'banner', 'OSM 2', 'osm-2', '0', '49', '0', 'osmbanner2.png', 'http://www.opensourcematters.org', '2004-07-07 15:31:29', '1', '0', '0000-00-00 00:00:00', '', '', '13', '', '0', '2', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('3', '1', '', 'Joomla!', 'joomla', '0', '26', '0', '', 'http://www.joomla.org', '2006-05-29 14:21:28', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nJoomla! The most popular and widely used Open Source CMS Project in the world.', '14', '', '0', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('4', '1', '', 'JoomlaCode', 'joomlacode', '0', '26', '0', '', 'http://joomlacode.org', '2006-05-29 14:19:26', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nJoomlaCode, development and distribution made easy.', '14', '', '0', '2', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('5', '1', '', 'Joomla! Extensions', 'joomla-extensions', '0', '21', '0', '', 'http://extensions.joomla.org', '2006-05-29 14:23:21', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nJoomla! Components, Modules, Plugins and Languages by the bucket load.', '14', '', '0', '3', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('6', '1', '', 'Joomla! Shop', 'joomla-shop', '0', '21', '0', '', 'http://shop.joomla.org', '2006-05-29 14:23:21', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nFor all your Joomla! merchandise.', '14', '', '0', '4', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('7', '1', '', 'Joomla! Promo Shop', 'joomla-promo-shop', '0', '8', '1', 'shop-ad.jpg', 'http://shop.joomla.org', '2007-09-19 17:26:24', '1', '0', '0000-00-00 00:00:00', '', '', '33', '', '0', '3', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('8', '1', '', 'Joomla! Promo Books', 'joomla-promo-books', '0', '10', '0', 'shop-ad-books.jpg', 'http://shop.joomla.org/index.php?option=com_wrapper&Itemid=8', '2007-09-19 17:28:01', '1', '0', '0000-00-00 00:00:00', '', '', '33', '', '0', '4', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('9', '2', '', 'Web Empresa Hosting Joomla!', 'web-empresa', '0', '11', '1', '', 'http://www.webempresa.com/', '2008-07-09 01:15:06', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nServicios Profesionales para Joomla:\r\nHosting, Servicio Técnico, Formación y JoomlaFácil.', '14', '', '0', '5', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''), ('10', '3', '', 'CompluSoft', 'complusoft', '0', '12', '1', '', 'http://www.complusoft.es/', '2009-11-05 15:43:19', '1', '0', '0000-00-00 00:00:00', '', '<a href=\"{CLICKURL}\" target=\"_blank\">{NAME}</a>\r\n<br/>\r\nEmpresa de informática situada en la zona este de la Comunidad de Madrid presta sus servicios en las más importantes consultoras y clientes finales.', '14', '', '0', '6', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');
CREATE TABLE `#__bannerclient` (   `cid` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `contact` varchar(255) NOT NULL DEFAULT '',   `email` varchar(255) NOT NULL DEFAULT '',   `extrainfo` text NOT NULL,   `checked_out` tinyint(1) NOT NULL DEFAULT '0',   `checked_out_time` time DEFAULT NULL,   `editor` varchar(50) DEFAULT NULL,   PRIMARY KEY (`cid`) ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
INSERT INTO `#__bannerclient` VALUES ('1', 'Open Source Matters', 'Administrator', 'admin@opensourcematters.org', '', '0', '00:00:00', NULL), ('2', 'Web Empresa', 'Web Empresa', 'info@webempresa.com', 'Patrocinador Joomla! Spanish', '0', '00:00:00', ''), ('3', 'CompluSoft', 'CompluSoft', 'info@complusoft.es', 'Patrocinador Joomla! Spanish', '0', '00:00:00', '');
CREATE TABLE `#__bannertrack` (   `track_date` date NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `parent_id` int(11) NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL DEFAULT '',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `image` varchar(255) NOT NULL DEFAULT '',   `section` varchar(50) NOT NULL DEFAULT '',   `image_position` varchar(30) NOT NULL DEFAULT '',   `description` text NOT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `editor` varchar(50) DEFAULT NULL,   `ordering` int(11) NOT NULL DEFAULT '0',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `count` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   PRIMARY KEY (`id`),   KEY `cat_idx` (`section`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`) ) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;
INSERT INTO `#__categories` VALUES ('1', '0', 'Últimas noticias', '', 'latest-news', 'taking_notes.jpg', '1', 'left', 'Las últimas noticias del equipo de Joomla!', '1', '0', '0000-00-00 00:00:00', '', '1', '0', '1', ''), ('2', '0', 'Joomla! enlaces específicos', '', 'joomla-specific-links', 'clock.jpg', 'com_weblinks', 'left', 'Una selección de enlaces relacionados con el proyecto de Joomla!.', '1', '0', '0000-00-00 00:00:00', NULL, '1', '0', '0', ''), ('3', '0', 'Destacado', '', 'newsflash', '', '1', 'left', '', '1', '0', '0000-00-00 00:00:00', '', '2', '0', '0', ''), ('4', '0', 'Joomla!', '', 'joomla', '', 'com_newsfeeds', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '2', '0', '0', ''), ('5', '0', 'Negocios: General', '', 'business-general', '', 'com_newsfeeds', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '1', '0', '0', ''), ('6', '0', 'Linux', '', 'linux', '', 'com_newsfeeds', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '6', '0', '0', ''), ('7', '0', 'Internet', '', 'internet', '', 'com_newsfeeds', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '7', '0', '0', ''), ('12', '0', 'Contactos', '', 'contacts', '', 'com_contact_details', 'left', 'Detalles de contacto para este sitio web', '1', '0', '0000-00-00 00:00:00', NULL, '0', '0', '0', ''), ('13', '0', 'Joomla', '', 'joomla', '', 'com_banner', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '0', '0', '0', ''), ('14', '0', 'Anuncios', '', 'text-ads', '', 'com_banner', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '0', '0', '0', ''), ('15', '0', 'Características', '', 'features', '', 'com_content', 'left', '', '0', '0', '0000-00-00 00:00:00', NULL, '6', '0', '0', ''), ('17', '0', 'Beneficios', '', 'benefits', '', 'com_content', 'left', '', '0', '0', '0000-00-00 00:00:00', NULL, '4', '0', '0', ''), ('18', '0', 'Plataformas', '', 'platforms', '', 'com_content', 'left', '', '0', '0', '0000-00-00 00:00:00', NULL, '3', '0', '0', ''), ('19', '0', 'Otros recursos', '', 'other-resources', '', 'com_weblinks', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '2', '0', '0', ''), ('33', '0', 'Joomla! Promoción', '', 'joomla-promo', '', 'com_banner', 'left', '', '1', '0', '0000-00-00 00:00:00', NULL, '1', '0', '0', ''), ('34', '0', 'Joomla! Spanish', '', 'joomla-spanish', '', 'com_newsfeeds', 'left', 'Grupo Joomla! Spanish y patrocinadores expertos en Joomla!', '1', '0', '0000-00-00 00:00:00', NULL, '8', '0', '0', '');
CREATE TABLE `#__components` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(50) NOT NULL DEFAULT '',   `link` varchar(255) NOT NULL DEFAULT '',   `menuid` int(11) unsigned NOT NULL DEFAULT '0',   `parent` int(11) unsigned NOT NULL DEFAULT '0',   `admin_menu_link` varchar(255) NOT NULL DEFAULT '',   `admin_menu_alt` varchar(255) NOT NULL DEFAULT '',   `option` varchar(50) NOT NULL DEFAULT '',   `ordering` int(11) NOT NULL DEFAULT '0',   `admin_menu_img` varchar(255) NOT NULL DEFAULT '',   `iscore` tinyint(4) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `enabled` tinyint(4) NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `parent_option` (`parent`,`option`(32)) ) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;
INSERT INTO `#__components` VALUES ('1', 'Banners', '', '0', '0', '', 'Banner Management', 'com_banners', '0', 'js/ThemeOffice/component.png', '0', 'track_impressions=0\ntrack_clicks=0\ntag_prefix=\n\n', '1'), ('2', 'Banners', '', '0', '1', 'option=com_banners', 'Active Banners', 'com_banners', '1', 'js/ThemeOffice/edit.png', '0', '', '1'), ('3', 'Clientes', '', '0', '1', 'option=com_banners&c=client', 'Manage Clients', 'com_banners', '2', 'js/ThemeOffice/categories.png', '0', '', '1'), ('4', 'Enlaces Web', 'option=com_weblinks', '0', '0', '', 'Manage Weblinks', 'com_weblinks', '0', 'js/ThemeOffice/component.png', '0', 'show_comp_description=1\ncomp_description=\nshow_link_hits=1\nshow_link_description=1\nshow_other_cats=1\nshow_headings=1\nshow_page_title=1\nlink_target=0\nlink_icons=\n\n', '1'), ('5', 'Enlaces', '', '0', '4', 'option=com_weblinks', 'View existing weblinks', 'com_weblinks', '1', 'js/ThemeOffice/edit.png', '0', '', '1'), ('6', 'Categorías', '', '0', '4', 'option=com_categories&section=com_weblinks', 'Manage weblink categories', '', '2', 'js/ThemeOffice/categories.png', '0', '', '1'), ('7', 'Contactos', 'option=com_contact', '0', '0', '', 'Edit contact details', 'com_contact', '0', 'js/ThemeOffice/component.png', '1', 'contact_icons=0\nicon_address=\nicon_email=\nicon_telephone=\nicon_fax=\nicon_misc=\nshow_headings=1\nshow_position=1\nshow_email=0\nshow_telephone=1\nshow_mobile=1\nshow_fax=1\nbannedEmail=\nbannedSubject=\nbannedText=\nsession=1\ncustomReply=0\n\n', '1'), ('8', 'Contactos', '', '0', '7', 'option=com_contact', 'Edit contact details', 'com_contact', '0', 'js/ThemeOffice/edit.png', '1', '', '1'), ('9', 'Categorías', '', '0', '7', 'option=com_categories&section=com_contact_details', 'Manage contact categories', '', '2', 'js/ThemeOffice/categories.png', '1', '', '1'), ('10', 'Encuesta', 'option=com_poll', '0', '0', 'option=com_poll', 'Manage Polls', 'com_poll', '0', 'js/ThemeOffice/component.png', '0', '', '1'), ('11', 'News Feeds', 'option=com_newsfeeds', '0', '0', '', 'News Feeds Management', 'com_newsfeeds', '0', 'js/ThemeOffice/component.png', '0', '', '1'), ('12', 'Feeds', '', '0', '11', 'option=com_newsfeeds', 'Manage News Feeds', 'com_newsfeeds', '1', 'js/ThemeOffice/edit.png', '0', '', '1'), ('13', 'Categorías', '', '0', '11', 'option=com_categories&section=com_newsfeeds', 'Manage Categories', '', '2', 'js/ThemeOffice/categories.png', '0', '', '1'), ('14', 'Usuario', 'option=com_user', '0', '0', '', '', 'com_user', '0', '', '1', '', '1'), ('15', 'Buscar', 'option=com_search', '0', '0', 'option=com_search', 'Search Statistics', 'com_search', '0', 'js/ThemeOffice/component.png', '1', 'enabled=0\n\n', '1'), ('16', 'Categorías', '', '0', '1', 'option=com_categories&section=com_banner', 'Categories', '', '3', '', '1', '', '1'), ('17', 'Wrapper', 'option=com_wrapper', '0', '0', '', 'Wrapper', 'com_wrapper', '0', '', '1', '', '1'), ('18', 'Mail para', '', '0', '0', '', '', 'com_mailto', '0', '', '1', '', '1'), ('19', 'Administrador Media', '', '0', '0', 'option=com_media', 'Media Manager', 'com_media', '0', '', '1', 'upload_extensions=bmp,csv,doc,epg,gif,ico,jpg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,EPG,GIF,ICO,JPG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\nupload_maxsize=10000000\nfile_path=images\nimage_path=images/stories\nrestrict_uploads=1\ncheck_mime=1\nimage_extensions=bmp,gif,jpg,png\nignore_extensions=\nupload_mime=image/jpeg,image/gif,image/png,image/bmp,application/x-shockwave-flash,application/msword,application/excel,application/pdf,application/powerpoint,text/plain,application/x-zip\nupload_mime_illegal=text/html', '1'), ('20', 'Artículos', 'option=com_content', '0', '0', '', '', 'com_content', '0', '', '1', 'show_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\nfeed_summary=0\n\n', '1'), ('21', 'Administrar Configuración', '', '0', '0', '', 'Configuration', 'com_config', '0', '', '1', '', '1'), ('22', 'Administrar Instalaciones', '', '0', '0', '', 'Installer', 'com_installer', '0', '', '1', '', '1'), ('23', 'Gestor de idiomas', '', '0', '0', '', 'Idiomas', 'com_languages', '0', '', '1', 'administrator=es-ES\nsite=es-ES', '1'), ('24', 'Mail masivo', '', '0', '0', '', 'Mass Mail', 'com_massmail', '0', '', '1', 'mailSubjectPrefix=\nmailBodySuffix=\n\n', '1'), ('25', 'Menú del editor', '', '0', '0', '', 'Menu Editor', 'com_menus', '0', '', '1', '', '1'), ('27', 'Mensajes', '', '0', '0', '', 'Messages', 'com_messages', '0', '', '1', '', '1'), ('28', 'Administrar modulos', '', '0', '0', '', 'Modules', 'com_modules', '0', '', '1', '', '1'), ('29', 'Administrar Plugin', '', '0', '0', '', 'Plugins', 'com_plugins', '0', '', '1', '', '1'), ('30', 'Administrar plantilla', '', '0', '0', '', 'Templates', 'com_templates', '0', '', '1', '', '1'), ('31', 'Administrar usuarios', '', '0', '0', '', 'Users', 'com_users', '0', '', '1', 'allowUserRegistration=1\nnew_usertype=Registered\nuseractivation=1\nfrontend_userparams=1\n\n', '1'), ('32', 'Administrar la caché', '', '0', '0', '', 'Cache', 'com_cache', '0', '', '1', '', '1'), ('33', 'Panel de Control', '', '0', '0', '', 'Control Panel', 'com_cpanel', '0', '', '1', '', '1'), ('34', 'Administrador de Traducciones', 'option=com_translationsmanager', '0', '0', 'option=com_translationsmanager', 'Administrador de Traducciones', 'com_translationsmanager', '0', 'class:language', '0', '', '1'), ('35', 'JXTC Primetime Slideshow', 'option=com_jxtcprimetime', '0', '0', 'option=com_jxtcprimetime', 'JXTC Primetime Slideshow', 'com_jxtcprimetime', '0', 'js/ThemeOffice/component.png', '0', 'mediasource=images\nthumbx=60\nthumby=60\nthumbsource=images\n', '1'), ('36', 'Slideshows', '', '0', '35', 'option=com_jxtcprimetime&view=slideshows', 'Slideshows', 'com_jxtcprimetime', '0', 'js/ThemeOffice/component.png', '0', '', '1'), ('37', 'Items', '', '0', '35', 'option=com_jxtcprimetime&c=item&view=items', 'Items', 'com_jxtcprimetime', '1', 'js/ThemeOffice/component.png', '0', '', '1'), ('38', 'COM_AKEEBA', 'option=com_akeeba', '0', '0', 'option=com_akeeba', 'COM_AKEEBA', 'com_akeeba', '0', 'components/com_akeeba/assets/images/akeeba-16.png', '0', 'siteurl=http://www.fmradioamiga.com.ar/\njlibrariesdir=/home/fmradio/public_html/libraries\njversion=1.5\nlastversion=3.3.1\nliveupdate=stuck=0\\nlastcheck=1330115874\\nupdatedata=\"{\\\"supported\\\":true,\\\"stuck\\\":false,\\\"version\\\":\\\"3.3.13\\\",\\\"date\\\":\\\"2012-01-29\\\",\\\"stability\\\":\\\"stable\\\",\\\"downloadURL\\\":\\\"http:\\\\\\/\\\\\\/joomlacode.org\\\\\\/gf\\\\\\/download\\\\\\/frsrelease\\\\\\/16484\\\\\\/71856\\\\\\/com_akeeba-3.3.13-core.zip\\\"}\"\\n\\n\n\n', '1');
CREATE TABLE `#__contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `con_position` varchar(255) DEFAULT NULL,   `address` text,   `suburb` varchar(100) DEFAULT NULL,   `state` varchar(100) DEFAULT NULL,   `country` varchar(100) DEFAULT NULL,   `postcode` varchar(100) DEFAULT NULL,   `telephone` varchar(255) DEFAULT NULL,   `fax` varchar(255) DEFAULT NULL,   `misc` mediumtext,   `image` varchar(255) DEFAULT NULL,   `imagepos` varchar(20) DEFAULT NULL,   `email_to` varchar(255) DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) unsigned NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `mobile` varchar(255) NOT NULL DEFAULT '',   `webpage` varchar(255) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `catid` (`catid`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__contact_details` VALUES ('1', 'Name', 'name', 'Position', 'Street', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', 'Miscellanous info', 'powered_by.png', 'top', 'email@email.com', '1', '1', '0', '0000-00-00 00:00:00', '1', 'show_name=1\r\nshow_position=1\r\nshow_email=0\r\nshow_street_address=1\r\nshow_suburb=1\r\nshow_state=1\r\nshow_postcode=1\r\nshow_country=1\r\nshow_telephone=1\r\nshow_mobile=1\r\nshow_fax=1\r\nshow_webpage=1\r\nshow_misc=1\r\nshow_image=1\r\nallow_vcard=0\r\ncontact_icons=0\r\nicon_address=\r\nicon_email=\r\nicon_telephone=\r\nicon_fax=\r\nicon_misc=\r\nshow_email_form=1\r\nemail_description=1\r\nshow_email_copy=1\r\nbanned_email=\r\nbanned_subject=\r\nbanned_text=', '0', '12', '0', '', '');
CREATE TABLE `#__content` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `title_alias` varchar(255) NOT NULL DEFAULT '',   `introtext` mediumtext NOT NULL,   `fulltext` mediumtext NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `sectionid` int(11) unsigned NOT NULL DEFAULT '0',   `mask` int(11) unsigned NOT NULL DEFAULT '0',   `catid` int(11) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(11) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text NOT NULL,   `urls` text NOT NULL,   `attribs` text NOT NULL,   `version` int(11) unsigned NOT NULL DEFAULT '1',   `parentid` int(11) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text NOT NULL,   `metadesc` text NOT NULL,   `access` int(11) unsigned NOT NULL DEFAULT '0',   `hits` int(11) unsigned NOT NULL DEFAULT '0',   `metadata` text NOT NULL,   PRIMARY KEY (`id`),   KEY `idx_section` (`sectionid`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`) ) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
INSERT INTO `#__content` VALUES ('44', 'Quienes Somos', 'quienes-somos', '', '<p>.</p>', '', '1', '0', '0', '0', '2011-12-11 21:47:50', '62', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2011-12-11 21:47:50', '0000-00-00 00:00:00', '', '', 'show_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_vote=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nlanguage=\nkeyref=\nreadmore=', '1', '0', '1', '', '', '0', '3', 'robots=\nauthor=');
CREATE TABLE `#__content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(11) unsigned NOT NULL DEFAULT '0',   `rating_count` int(11) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__core_acl_aro` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `section_value` varchar(240) NOT NULL DEFAULT '0',   `value` varchar(240) NOT NULL DEFAULT '',   `order_value` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `hidden` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   UNIQUE KEY `jos_section_value_value_aro` (`section_value`(100),`value`(100)),   KEY `jos_gacl_hidden_aro` (`hidden`) ) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `#__core_acl_aro` VALUES ('10', 'users', '62', '0', 'Administrator', '0');
CREATE TABLE `#__core_acl_aro_groups` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `parent_id` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) NOT NULL DEFAULT '',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `value` varchar(255) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `jos_gacl_parent_id_aro_groups` (`parent_id`),   KEY `jos_gacl_lft_rgt_aro_groups` (`lft`,`rgt`) ) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
INSERT INTO `#__core_acl_aro_groups` VALUES ('17', '0', 'ROOT', '1', '22', 'ROOT'), ('28', '17', 'USERS', '2', '21', 'USERS'), ('29', '28', 'Public Frontend', '3', '12', 'Public Frontend'), ('18', '29', 'Registered', '4', '11', 'Registered'), ('19', '18', 'Author', '5', '10', 'Author'), ('20', '19', 'Editor', '6', '9', 'Editor'), ('21', '20', 'Publisher', '7', '8', 'Publisher'), ('30', '28', 'Public Backend', '13', '20', 'Public Backend'), ('23', '30', 'Manager', '14', '19', 'Manager'), ('24', '23', 'Administrator', '15', '18', 'Administrator'), ('25', '24', 'Super Administrator', '16', '17', 'Super Administrator');
CREATE TABLE `#__core_acl_aro_map` (   `acl_id` int(11) NOT NULL DEFAULT '0',   `section_value` varchar(230) NOT NULL DEFAULT '0',   `value` varchar(100) NOT NULL,   PRIMARY KEY (`acl_id`,`section_value`,`value`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__core_acl_aro_sections` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `value` varchar(230) NOT NULL DEFAULT '',   `order_value` int(11) NOT NULL DEFAULT '0',   `name` varchar(230) NOT NULL DEFAULT '',   `hidden` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   UNIQUE KEY `jos_gacl_value_aro_sections` (`value`),   KEY `jos_gacl_hidden_aro_sections` (`hidden`) ) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `#__core_acl_aro_sections` VALUES ('10', 'users', '1', 'Users', '0');
CREATE TABLE `#__core_acl_groups_aro_map` (   `group_id` int(11) NOT NULL DEFAULT '0',   `section_value` varchar(240) NOT NULL DEFAULT '',   `aro_id` int(11) NOT NULL DEFAULT '0',   UNIQUE KEY `group_id_aro_id_groups_aro_map` (`group_id`,`section_value`,`aro_id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__core_acl_groups_aro_map` VALUES ('25', '', '10');
CREATE TABLE `#__core_log_items` (   `time_stamp` date NOT NULL DEFAULT '0000-00-00',   `item_table` varchar(50) NOT NULL DEFAULT '',   `item_id` int(11) unsigned NOT NULL DEFAULT '0',   `hits` int(11) unsigned NOT NULL DEFAULT '0' ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__core_log_searches` (   `search_term` varchar(128) NOT NULL DEFAULT '',   `hits` int(11) unsigned NOT NULL DEFAULT '0' ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__groups` (   `id` tinyint(3) unsigned NOT NULL DEFAULT '0',   `name` varchar(50) NOT NULL DEFAULT '',   PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__groups` VALUES ('0', 'Public'), ('1', 'Registered'), ('2', 'Special');
CREATE TABLE `#__jxtc_primetime` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `checked_out` int(11) NOT NULL,   `checked_out_time` datetime NOT NULL,   `home` char(1) NOT NULL,   `title` varchar(255) NOT NULL,   `published` tinyint(4) NOT NULL,   `width` int(4) NOT NULL,   `height` int(4) NOT NULL,   `imageDuration` int(4) NOT NULL,   `textColor` text NOT NULL,   `textSize` int(3) NOT NULL,   `textAlign` text NOT NULL,   `rotatingWheel` char(1) NOT NULL,   `flyingSparkles` char(1) NOT NULL,   `showThumbs` char(1) NOT NULL,   `thumbWidth` smallint(3) NOT NULL,   `thumbHeight` smallint(3) NOT NULL,   `thumbGap` smallint(3) NOT NULL,   `bgColor` char(6) NOT NULL,   `bgAlpha` smallint(3) NOT NULL,   `borderColor` char(6) NOT NULL,   `borderHighlite` char(6) NOT NULL,   `borderSize` smallint(2) NOT NULL,   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
INSERT INTO `#__jxtc_primetime` VALUES ('1', '0', '0000-00-00 00:00:00', '0', 'Slide', '1', '365', '250', '10', 'FFFFFF', '12', 'l', '0', '0', '0', '45', '35', '5', '000000', '65', '474747', 'a9a9a9', '1');
CREATE TABLE `#__jxtc_primetime_item` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `published` tinyint(4) NOT NULL,   `checked_out` int(11) NOT NULL,   `checked_out_time` datetime NOT NULL,   `ordering` int(11) NOT NULL,   `title` varchar(128) NOT NULL,   `image` varchar(255) NOT NULL DEFAULT '',   `thumbnail` varchar(255) NOT NULL DEFAULT '',   `trans` int(11) NOT NULL,   `transtime` float NOT NULL,   `text` varchar(4096) NOT NULL DEFAULT '',   `url` varchar(1024) NOT NULL DEFAULT '',   `target` varchar(16) NOT NULL DEFAULT '',   `slideshow_id` int(11) NOT NULL,   UNIQUE KEY `id` (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
INSERT INTO `#__jxtc_primetime_item` VALUES ('1', '1', '0', '0000-00-00 00:00:00', '1', 'Revolucion de Adoracion', 'images/noticias/revolucion_de_adoracion.jpg', 'images/noticias/revolucion_de_adoracion.jpg', '3', '5', '', '', '_top', '1'), ('2', '1', '0', '0000-00-00 00:00:00', '1', 'Nuevo video de alex campos', 'images/noticias/video_alex.jpg', 'images/noticias/video_alex.jpg', '3', '5', '', '', '_top', '1');
CREATE TABLE `#__menu` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `menutype` varchar(75) DEFAULT NULL,   `name` varchar(255) DEFAULT NULL,   `alias` varchar(255) NOT NULL DEFAULT '',   `link` text,   `type` varchar(50) NOT NULL DEFAULT '',   `published` tinyint(1) NOT NULL DEFAULT '0',   `parent` int(11) unsigned NOT NULL DEFAULT '0',   `componentid` int(11) unsigned NOT NULL DEFAULT '0',   `sublevel` int(11) DEFAULT '0',   `ordering` int(11) DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `pollid` int(11) NOT NULL DEFAULT '0',   `browserNav` tinyint(4) DEFAULT '0',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `utaccess` tinyint(3) unsigned NOT NULL DEFAULT '0',   `params` text NOT NULL,   `lft` int(11) unsigned NOT NULL DEFAULT '0',   `rgt` int(11) unsigned NOT NULL DEFAULT '0',   `home` int(1) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `componentid` (`componentid`,`menutype`,`published`,`access`),   KEY `menutype` (`menutype`) ) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;
INSERT INTO `#__menu` VALUES ('1', 'topmenu', 'Inicio', 'home', 'index.php?option=com_content&view=frontpage', 'component', '1', '0', '20', '0', '5', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'num_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\norderby_pri=\norderby_sec=front\nmulti_column_order=1\nshow_pagination=2\nshow_pagination_results=1\nshow_feed_link=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\nfeed_summary=\npage_title=Fm Radio Amiga 88.5\nshow_page_title=0\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', '0', '0', '1'), ('2', 'mainmenu', 'Licencia', 'joomla-license', 'index.php?option=com_content&view=article&id=5', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('41', 'mainmenu', 'FAQ', 'faq', 'index.php?option=com_content&view=section&id=3', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\nshow_description=0\nshow_description_image=0\nshow_categories=1\nshow_empty_categories=0\nshow_cat_num_articles=1\nshow_category_description=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby=\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1', '0', '0', '0'), ('11', 'othermenu', 'Joomla!', 'joomla-home', 'http://www.joomla.org', 'url', '1', '0', '0', '0', '1', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'menu_image=-1\n\n', '0', '0', '0'), ('12', 'othermenu', 'Foros Joomla!', 'joomla-forums', 'http://forum.joomla.org', 'url', '1', '0', '0', '0', '2', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'menu_image=-1\n\n', '0', '0', '0'), ('13', 'othermenu', 'Ayuda Joomla!', 'joomla-help', 'http://help.joomla.org', 'url', '1', '0', '0', '0', '3', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'menu_image=-1\n\n', '0', '0', '0'), ('14', 'othermenu', 'OSM', 'osm-home', 'http://www.opensourcematters.org', 'url', '1', '0', '0', '0', '4', '0', '0000-00-00 00:00:00', '0', '0', '0', '4', 'menu_image=-1\n\n', '0', '0', '0'), ('15', 'othermenu', 'Administración', 'administrator', 'administrator/', 'url', '1', '0', '0', '0', '5', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'menu_image=-1\n\n', '0', '0', '0'), ('18', 'topmenu', 'Noticias', 'news', 'index.php?option=com_newsfeeds&view=newsfeed&id=1&feedid=1', 'component', '-2', '0', '11', '0', '1', '0', '0000-00-00 00:00:00', '0', '0', '0', '3', 'show_page_title=1\npage_title=News\npageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_headings=1\nshow_name=1\nshow_articles=1\nshow_link=1\nshow_other_cats=1\nshow_cat_description=1\nshow_cat_items=1\nshow_feed_image=1\nshow_feed_description=1\nshow_item_description=1\nfeed_word_count=0\n\n', '0', '0', '0'), ('20', 'usermenu', 'Tu Perfil', 'your-details', 'index.php?option=com_user&view=user&task=edit', 'component', '1', '0', '14', '0', '1', '0', '0000-00-00 00:00:00', '0', '0', '1', '3', '', '0', '0', '0'), ('24', 'usermenu', 'Cerrar sesión', 'logout', 'index.php?option=com_user&view=login', 'component', '1', '0', '14', '0', '4', '0', '0000-00-00 00:00:00', '0', '0', '1', '3', '', '0', '0', '0'), ('38', 'keyconcepts', 'Presentaciones', 'content-layouts', 'index.php?option=com_content&view=article&id=24', 'component', '1', '0', '20', '0', '2', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('27', 'mainmenu', 'Visión general', 'joomla-overview', 'index.php?option=com_content&view=article&id=19', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('28', 'topmenu', 'Sobre Joomla!', 'about-joomla', 'index.php?option=com_content&view=article&id=25', 'component', '-2', '0', '20', '0', '2', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('29', 'topmenu', 'Características', 'features', 'index.php?option=com_content&view=article&id=22', 'component', '-2', '0', '20', '0', '3', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('30', 'topmenu', 'La comunidad', 'the-community', 'index.php?option=com_content&view=article&id=27', 'component', '-2', '0', '20', '0', '4', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('34', 'mainmenu', '¿Novedades en la 1.5?', 'what-is-new-in-1-5', 'index.php?option=com_content&view=article&id=22', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('40', 'keyconcepts', 'Extensiones', 'extensions', 'index.php?option=com_content&view=article&id=26', 'component', '1', '0', '20', '0', '1', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('37', 'mainmenu', 'Más sobre Joomla!', 'more-about-joomla', 'index.php?option=com_content&view=section&id=4', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\nshow_description=0\nshow_description_image=0\nshow_categories=1\nshow_empty_categories=0\nshow_cat_num_articles=1\nshow_category_description=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby=\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1', '0', '0', '0'), ('43', 'keyconcepts', 'Páginas de ejemplo', 'example-pages', 'index.php?option=com_content&view=article&id=43', 'component', '1', '0', '20', '0', '3', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'pageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('44', 'ExamplePages', 'Blog de Sección', 'section-blog', 'index.php?option=com_content&view=section&layout=blog&id=3', 'component', '1', '0', '20', '0', '1', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=Example of Section Blog layout (FAQ section)\nshow_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\nshow_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_pri=\norderby_sec=\nshow_pagination=2\nshow_pagination_results=1\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('45', 'ExamplePages', 'Tabla de Sección', 'section-table', 'index.php?option=com_content&view=section&id=3', 'component', '1', '0', '20', '0', '2', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=Example of Table Blog layout (FAQ section)\nshow_description=0\nshow_description_image=0\nshow_categories=1\nshow_empty_categories=0\nshow_cat_num_articles=1\nshow_category_description=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby=\nshow_noauth=0\nshow_title=1\nnlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('46', 'ExamplePages', 'Blog de Categoría', 'categoryblog', 'index.php?option=com_content&view=category&layout=blog&id=31', 'component', '1', '0', '20', '0', '3', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=Example of Category Blog layout (FAQs/General category)\nshow_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\nshow_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_pri=\norderby_sec=\nshow_pagination=2\nshow_pagination_results=1\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('47', 'ExamplePages', 'Tabla de Categoría', 'category-table', 'index.php?option=com_content&view=category&id=32', 'component', '1', '0', '20', '0', '4', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=Example of Category Table layout (FAQs/Languages category)\nshow_headings=1\nshow_date=0\ndate_format=\nfilter=1\nfilter_type=title\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_sec=\nshow_pagination=1\nshow_pagination_limit=1\nshow_noauth=0\nshow_title=1\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('48', 'mainmenu', 'Enlaces', 'web-links', 'index.php?option=com_weblinks&view=categories', 'component', '-2', '0', '4', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'page_title=Weblinks\nimage=-1\nimage_align=right\npageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_comp_description=1\ncomp_description=\nshow_link_hits=1\nshow_link_description=1\nshow_other_cats=1\nshow_headings=1\nshow_page_title=1\nlink_target=0\nlink_icons=\n\n', '0', '0', '0'), ('49', 'mainmenu', 'Servidor de noticias', 'news-feeds', 'index.php?option=com_newsfeeds&view=categories', 'component', '-2', '0', '11', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=Newsfeeds\nshow_comp_description=1\ncomp_description=\nimage=-1\nimage_align=right\npageclass_sfx=\nmenu_image=-1\nsecure=0\nshow_headings=1\nshow_name=1\nshow_articles=1\nshow_link=1\nshow_other_cats=1\nshow_cat_description=1\nshow_cat_items=1\nshow_feed_image=1\nshow_feed_description=1\nshow_item_description=1\nfeed_word_count=0\n\n', '0', '0', '0'), ('50', 'mainmenu', 'Noticias', 'the-news', 'index.php?option=com_content&view=category&layout=blog&id=1', 'component', '-2', '0', '20', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_page_title=1\npage_title=The News\nshow_description=0\nshow_description_image=0\nnum_leading_articles=1\nnum_intro_articles=4\nnum_columns=2\nnum_links=4\nshow_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\norderby_pri=\norderby_sec=\nshow_pagination=2\nshow_pagination_results=1\nshow_noauth=0\nlink_titles=0\nshow_intro=1\nshow_section=0\nlink_section=0\nshow_category=0\nlink_category=0\nshow_author=1\nshow_create_date=1\nshow_modify_date=1\nshow_item_navigation=0\nshow_readmore=1\nshow_vote=0\nshow_icons=1\nshow_pdf_icon=1\nshow_print_icon=1\nshow_email_icon=1\nshow_hits=1\n\n', '0', '0', '0'), ('51', 'usermenu', 'Enviar artículo', 'submit-an-article', 'index.php?option=com_content&view=article&layout=form', 'component', '1', '0', '20', '0', '2', '0', '0000-00-00 00:00:00', '0', '0', '2', '0', '', '0', '0', '0'), ('52', 'usermenu', 'Enviar enlace', 'submit-a-web-link', 'index.php?option=com_weblinks&view=weblink&layout=form', 'component', '1', '0', '4', '0', '3', '0', '0000-00-00 00:00:00', '0', '0', '2', '0', '', '0', '0', '0'), ('53', 'othermenu', 'Joomla! Spanish', ' Joomla! Spanish', 'http://www.joomlaspanish.org/', 'url', '1', '0', '0', '0', '5', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'menu_image=-1\n\n', '0', '0', '0'), ('54', 'topmenu', 'Quienes Somos', 'quienes-somos', 'index.php?option=com_content&view=article&id=44', 'component', '1', '0', '20', '0', '6', '0', '0000-00-00 00:00:00', '0', '0', '0', '0', 'show_noauth=\nshow_title=\nlink_titles=\nshow_intro=\nshow_section=\nlink_section=\nshow_category=\nlink_category=\nshow_author=\nshow_create_date=\nshow_modify_date=\nshow_item_navigation=\nshow_readmore=\nshow_vote=\nshow_icons=\nshow_pdf_icon=\nshow_print_icon=\nshow_email_icon=\nshow_hits=\nfeed_summary=\npage_title=\nshow_page_title=1\npageclass_sfx=\nmenu_image=-1\nsecure=0\n\n', '0', '0', '0');
CREATE TABLE `#__menu_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `menutype` varchar(75) NOT NULL DEFAULT '',   `title` varchar(255) NOT NULL DEFAULT '',   `description` varchar(255) NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   UNIQUE KEY `menutype` (`menutype`) ) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
INSERT INTO `#__menu_types` VALUES ('1', 'mainmenu', 'Menú principal', 'Este es el menú principal del sitio'), ('2', 'usermenu', 'Menú de usuario', 'Menú para usuarios logueados'), ('3', 'topmenu', 'Menú principal', 'Navegador principal'), ('4', 'othermenu', 'Recursos', 'Enlaces adicionales'), ('5', 'ExamplePages', 'Páginas de ejemplo', 'Páginas de ejemplo'), ('6', 'keyconcepts', 'Conceptos clave', 'Descripción de alguna información crítica para usuarios nuevos.');
CREATE TABLE `#__messages` (   `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',   `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',   `folder_id` int(10) unsigned NOT NULL DEFAULT '0',   `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `state` int(11) NOT NULL DEFAULT '0',   `priority` int(1) unsigned NOT NULL DEFAULT '0',   `subject` text NOT NULL,   `message` text NOT NULL,   PRIMARY KEY (`message_id`),   KEY `useridto_state` (`user_id_to`,`state`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__messages_cfg` (   `user_id` int(10) unsigned NOT NULL DEFAULT '0',   `cfg_name` varchar(100) NOT NULL DEFAULT '',   `cfg_value` varchar(255) NOT NULL DEFAULT '',   UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__migration_backlinks` (   `itemid` int(11) NOT NULL,   `name` varchar(100) NOT NULL,   `url` text NOT NULL,   `sefurl` text NOT NULL,   `newurl` text NOT NULL,   PRIMARY KEY (`itemid`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__modules` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` text NOT NULL,   `content` text NOT NULL,   `ordering` int(11) NOT NULL DEFAULT '0',   `position` varchar(50) DEFAULT NULL,   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `published` tinyint(1) NOT NULL DEFAULT '0',   `module` varchar(50) DEFAULT NULL,   `numnews` int(11) NOT NULL DEFAULT '0',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',   `params` text NOT NULL,   `iscore` tinyint(4) NOT NULL DEFAULT '0',   `client_id` tinyint(4) NOT NULL DEFAULT '0',   `control` text NOT NULL,   PRIMARY KEY (`id`),   KEY `published` (`published`,`access`),   KEY `newsfeeds` (`module`,`published`) ) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;
INSERT INTO `#__modules` VALUES ('1', 'Menú principal', '', '1', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_mainmenu', '0', '0', '1', 'menutype=mainmenu\nmoduleclass_sfx=_menu\n', '1', '0', ''), ('2', 'Acceso', '', '1', 'login', '0', '0000-00-00 00:00:00', '1', 'mod_login', '0', '0', '1', '', '1', '1', ''), ('3', 'Popular', '', '3', 'cpanel', '0', '0000-00-00 00:00:00', '1', 'mod_popular', '0', '2', '1', '', '0', '1', ''), ('4', 'Artículos añadidos recientemente', '', '4', 'cpanel', '0', '0000-00-00 00:00:00', '1', 'mod_latest', '0', '2', '1', 'ordering=c_dsc\nuser_id=0\ncache=0\n\n', '0', '1', ''), ('5', 'Menú de estadísticas', '', '5', 'cpanel', '0', '0000-00-00 00:00:00', '1', 'mod_stats', '0', '2', '1', '', '0', '1', ''), ('6', 'Los mensajes no leídos', '', '1', 'header', '0', '0000-00-00 00:00:00', '1', 'mod_unread', '0', '2', '1', '', '1', '1', ''), ('7', 'Usuarios Online', '', '2', 'header', '0', '0000-00-00 00:00:00', '1', 'mod_online', '0', '2', '1', '', '1', '1', ''), ('8', 'Toolbar', '', '1', 'toolbar', '0', '0000-00-00 00:00:00', '1', 'mod_toolbar', '0', '2', '1', '', '1', '1', ''), ('9', 'Iconos rápidos', '', '1', 'icon', '0', '0000-00-00 00:00:00', '1', 'mod_quickicon', '0', '2', '1', '', '1', '1', ''), ('10', 'Usuarios identificados', '', '2', 'cpanel', '0', '0000-00-00 00:00:00', '1', 'mod_logged', '0', '2', '1', '', '0', '1', ''), ('11', 'Footer', '', '0', 'footer', '0', '0000-00-00 00:00:00', '1', 'mod_footer', '0', '0', '1', '', '1', '1', ''), ('12', 'Menú Admin', '', '1', 'menu', '0', '0000-00-00 00:00:00', '1', 'mod_menu', '0', '2', '1', '', '0', '1', ''), ('13', 'Admin SubMenu', '', '1', 'submenu', '0', '0000-00-00 00:00:00', '1', 'mod_submenu', '0', '2', '1', '', '0', '1', ''), ('14', 'Estado del usuario', '', '1', 'status', '0', '0000-00-00 00:00:00', '1', 'mod_status', '0', '2', '1', '', '0', '1', ''), ('15', 'Título', '', '1', 'title', '0', '0000-00-00 00:00:00', '1', 'mod_title', '0', '2', '1', '', '0', '1', ''), ('16', 'Encuestas', '', '1', 'right', '0', '0000-00-00 00:00:00', '1', 'mod_poll', '0', '0', '1', 'id=14\ncache=1', '0', '0', ''), ('17', 'Menú de usuario', '', '4', 'left', '0', '0000-00-00 00:00:00', '1', 'mod_mainmenu', '0', '1', '1', 'menutype=usermenu\nmoduleclass_sfx=_menu\ncache=1', '1', '0', ''), ('18', 'Acceso', '', '8', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_login', '0', '0', '1', 'greeting=1\nname=0', '1', '0', ''), ('19', 'Últimas noticias', '', '4', 'user1', '0', '0000-00-00 00:00:00', '1', 'mod_latestnews', '0', '0', '1', 'cache=1', '1', '0', ''), ('20', 'Estadísticas', '', '6', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_stats', '0', '0', '1', 'serverinfo=1\nsiteinfo=1\ncounter=1\nincrease=0\nmoduleclass_sfx=', '0', '0', ''), ('21', '¿Quién está en línea?', '', '3', 'right', '0', '0000-00-00 00:00:00', '1', 'mod_whosonline', '0', '0', '1', 'online=1\nusers=1\nmoduleclass_sfx=', '0', '0', ''), ('22', 'Popular', '', '6', 'user2', '0', '0000-00-00 00:00:00', '1', 'mod_mostread', '0', '0', '1', 'cache=1', '0', '0', ''), ('23', 'Archivo', '', '9', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_archive', '0', '0', '1', 'cache=1', '1', '0', ''), ('24', 'Secciones', '', '10', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_sections', '0', '0', '1', 'cache=1', '1', '0', ''), ('25', 'Newsflash', '', '1', 'top', '0', '0000-00-00 00:00:00', '1', 'mod_newsflash', '0', '0', '1', 'catid=3\r\nstyle=random\r\nitems=\r\nmoduleclass_sfx=', '0', '0', ''), ('26', 'Items relacionados', '', '11', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_related_items', '0', '0', '1', '', '0', '0', ''), ('27', 'Buscar', '', '1', 'user4', '0', '0000-00-00 00:00:00', '1', 'mod_search', '0', '0', '0', 'cache=1', '0', '0', ''), ('28', 'Imagen aleatoria', '', '9', 'right', '0', '0000-00-00 00:00:00', '0', 'mod_random_image', '0', '0', '1', '', '0', '0', ''), ('29', 'Menú principal', '', '2', 'user3', '0', '0000-00-00 00:00:00', '1', 'mod_mainmenu', '0', '0', '0', 'cache=1\nmenutype=topmenu\nmenu_style=list_flat\nmenu_images=n\nmenu_images_align=left\nexpand_menu=n\nclass_sfx=-nav\nmoduleclass_sfx=\nindent_image1=0\nindent_image2=0\nindent_image3=0\nindent_image4=0\nindent_image5=0\nindent_image6=0', '1', '0', ''), ('30', 'Anuncios', '', '1', 'footer', '0', '0000-00-00 00:00:00', '1', 'mod_banners', '0', '0', '0', 'target=1\ncount=1\ncid=1\ncatid=33\ntag_search=0\nordering=random\nheader_text=\nfooter_text=\nmoduleclass_sfx=\ncache=1\ncache_time=15\n\n', '1', '0', ''), ('31', 'Recursos', '', '2', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_mainmenu', '0', '0', '1', 'menutype=othermenu\nmenu_style=list\nstartLevel=0\nendLevel=0\nshowAllChildren=0\nwindow_open=\nshow_whitespace=0\ncache=1\ntag_id=\nclass_sfx=\nmoduleclass_sfx=_menu\nmaxdepth=10\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nactivate_parent=0\nfull_active_id=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=\n\n', '0', '0', ''), ('32', 'Wrapper', '', '12', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_wrapper', '0', '0', '1', '', '0', '0', ''), ('33', 'Pié de página', '', '2', 'footer', '0', '0000-00-00 00:00:00', '1', 'mod_footer', '0', '0', '0', 'cache=1\n\n', '1', '0', ''), ('34', 'Visor de noticias', '', '13', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_feed', '0', '0', '1', '', '1', '0', ''), ('35', 'Ruta', '', '1', 'breadcrumb', '0', '0000-00-00 00:00:00', '0', 'mod_breadcrumbs', '0', '0', '1', 'moduleclass_sfx=\ncache=0\nshowHome=1\nhomeText=Home\nshowComponent=1\nseparator=\n\n', '1', '0', ''), ('36', 'Syndication', '', '3', 'syndicate', '0', '0000-00-00 00:00:00', '1', 'mod_syndicate', '0', '0', '0', '', '1', '0', ''), ('37', 'Recursos', '', '7', 'left', '0', '0000-00-00 00:00:00', '1', 'mod_mainmenu', '0', '0', '1', 'menutype=othermenu\nmenu_style=list\nstartLevel=0\nendLevel=0\nshowAllChildren=0\nwindow_open=\nshow_whitespace=0\ncache=1\ntag_id=\nclass_sfx=\nmoduleclass_sfx=_menu\nmaxdepth=10\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nactivate_parent=0\nfull_active_id=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=\n\n', '0', '0', ''), ('38', 'Anuncios', '', '3', 'right', '0', '0000-00-00 00:00:00', '0', 'mod_banners', '0', '0', '1', 'count=4\r\nrandomise=0\r\ncid=0\r\ncatid=14\r\nheader_text=Featured Links:\r\nfooter_text=<a href=\"http://www.joomla.org\">Ads by Joomla!</a>\r\nmoduleclass_sfx=_text\r\ncache=0\r\n\r\n', '0', '0', ''), ('39', 'Páginas de ejemplo', '', '5', 'left', '0', '0000-00-00 00:00:00', '1', 'mod_mainmenu', '0', '0', '1', 'cache=1\nclass_sfx=\nmoduleclass_sfx=_menu\nmenutype=ExamplePages\nmenu_style=list_flat\nstartLevel=0\nendLevel=0\nshowAllChildren=0\nfull_active_id=0\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nactivate_parent=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=\nwindow_open=\n\n', '0', '0', ''), ('40', 'Conceptos clave', '', '3', 'left', '0', '0000-00-00 00:00:00', '0', 'mod_mainmenu', '0', '0', '1', 'cache=1\nclass_sfx=\nmoduleclass_sfx=_menu\nmenutype=keyconcepts\nmenu_style=list\nstartLevel=0\nendLevel=0\nshowAllChildren=0\nfull_active_id=0\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nactivate_parent=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=\nwindow_open=\n\n', '0', '0', ''), ('41', 'Bienvenido a Joomla!', '<div style=\"padding: 5px\"><p>Felicidades por elegir Joomla! como tu sistema de gestión de contenido. Esperamos que puedas crear con éxito un sitio web con nuestro programa y quizá que puedas aportar algo a la comunidad más adelante.</p><p>Para hacer que empiceces con Joomla! lo mejor y más rapidamente posible, queremos darte unos cuantos puntos de referencia a la documentación, preguntas frecuentas y ayuda sobre la seguridad de tu servidor. Un buen lugar donde empezar es en &quot;<a href=\"http://www.joomlaspanish.org/foros/index.php\" target=\"_blank\">Foros de la comunidad de Joomla! spanish</a>&quot;.</p><p>Nota: Para eliminar este mensaje de &quot;Bienvenido a Joomla!&quot; accede al gestor de módulos (en el gestor de extensiones).  Aquí hay un <a href=\"index.php?option=com_modules&amp;client=1\">enlace rápido</a> a esa pantalla.</p></div>', '1', 'cpanel', '0', '0000-00-00 00:00:00', '1', 'mod_custom', '0', '2', '1', 'moduleclass_sfx=\n\n', '1', '1', ''), ('42', 'Patrocinadores', '', '1', 'right', '0', '0000-00-00 00:00:00', '0', 'mod_banners', '0', '0', '1', 'target=1\ncount=1\ncid=2\ncatid=14\ntag_search=0\nordering=0\nheader_text=\nfooter_text=\nmoduleclass_sfx=\ncache=1\ncache_time=900\n\n', '0', '0', ''), ('43', 'Patrocinadores 1', '', '2', 'right', '0', '0000-00-00 00:00:00', '0', 'mod_banners', '0', '0', '0', 'target=1\ncount=1\ncid=3\ncatid=14\ntag_search=0\nordering=0\nheader_text=\nfooter_text=\nmoduleclass_sfx=\ncache=1\ncache_time=900\n\n', '0', '0', ''), ('44', 'Encabezado', '<table style=\"width: 767px; height: 128px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td><img src=\"images/stories/logofinal.png\" border=\"0\" /></td>\r\n<td align=\"right\" valign=\"top\"><br /><br /><img src=\"images/stories/escucha.png\" border=\"0\" /><br /> \r\n<object id=\"utv572291\" width=\"208\" height=\"25\" data=\"http://www.ustream.tv/flash/viewer.swf\" type=\"application/x-shockwave-flash\">\r\n<param name=\"flashvars\" value=\"autoplay=true&amp;brand=embed&amp;cid=8901586&amp;v3=1\" />\r\n<param name=\"allowfullscreen\" value=\"true\" />\r\n<param name=\"allowscriptaccess\" value=\"always\" />\r\n<param name=\"src\" value=\"http://www.ustream.tv/flash/viewer.swf\" />\r\n<param name=\"name\" value=\"utv_n_849956\" />\r\n</object>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '0', 'user3', '0', '0000-00-00 00:00:00', '1', 'mod_custom', '0', '0', '0', 'moduleclass_sfx=\n\n', '0', '0', ''), ('45', 'JoomlaXTC Primetime Slideshow Pro Module', '', '0', 'breadcrumb', '0', '0000-00-00 00:00:00', '1', 'mod_jxtc_primetime', '0', '0', '0', 'slideshowid=1\nmoduleclass_sfx=\n\n', '0', '0', ''), ('46', 'Banner', '<p><img src=\"images/stories/godtube.jpg\" border=\"0\" width=\"181\" height=\"109\" /></p>', '15', 'left', '0', '0000-00-00 00:00:00', '1', 'mod_custom', '0', '0', '0', 'moduleclass_sfx=\n\n', '0', '0', ''), ('47', 'Video Destacado', '<p>\r\n<object width=\"180\" height=\"150\" data=\"http://www.youtube.com/v/4sVBMkCkJz8?version=3&amp;hl=es_ES&amp;rel=0\" type=\"application/x-shockwave-flash\">\r\n<param name=\"allowFullScreen\" value=\"true\" />\r\n<param name=\"allowscriptaccess\" value=\"always\" />\r\n<param name=\"src\" value=\"http://www.youtube.com/v/4sVBMkCkJz8?version=3&amp;hl=es_ES&amp;rel=0\" />\r\n<param name=\"allowfullscreen\" value=\"true\" />\r\n</object>\r\n</p>', '14', 'left', '0', '0000-00-00 00:00:00', '1', 'mod_custom', '0', '0', '1', 'moduleclass_sfx=\n\n', '0', '0', ''), ('48', 'Akeeba Backup Notification Module', '', '97', 'icon', '0', '0000-00-00 00:00:00', '1', 'mod_akadmin', '0', '2', '1', '', '0', '1', '');
CREATE TABLE `#__modules_menu` (   `moduleid` int(11) NOT NULL DEFAULT '0',   `menuid` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`moduleid`,`menuid`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__modules_menu` VALUES ('1', '0'), ('16', '1'), ('17', '0'), ('18', '1'), ('19', '1'), ('19', '2'), ('19', '4'), ('19', '27'), ('19', '36'), ('21', '1'), ('22', '1'), ('22', '2'), ('22', '4'), ('22', '27'), ('22', '36'), ('25', '0'), ('27', '0'), ('29', '0'), ('30', '0'), ('31', '1'), ('32', '0'), ('33', '0'), ('34', '0'), ('35', '0'), ('36', '0'), ('38', '1'), ('39', '43'), ('39', '44'), ('39', '45'), ('39', '46'), ('39', '47'), ('40', '0'), ('42', '0'), ('43', '0'), ('44', '0'), ('45', '0'), ('46', '0'), ('47', '0'), ('48', '0');
CREATE TABLE `#__newsfeeds` (   `catid` int(11) NOT NULL DEFAULT '0',   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` text NOT NULL,   `alias` varchar(255) NOT NULL DEFAULT '',   `link` text NOT NULL,   `filename` varchar(200) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `numarticles` int(11) unsigned NOT NULL DEFAULT '1',   `cache_time` int(11) unsigned NOT NULL DEFAULT '3600',   `checked_out` tinyint(3) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `rtl` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `published` (`published`),   KEY `catid` (`catid`) ) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `#__newsfeeds` VALUES ('4', '1', 'Joomla! - Noticias oficiales', 'joomla-official-news', 'http://www.joomla.org/index.php?option=com_rss_xtd&feed=RSS2.0&type=com_frontpage&Itemid=1', '', '1', '5', '3600', '0', '0000-00-00 00:00:00', '8', '0'), ('4', '2', 'Joomla! - Noticias de la comunidad', 'joomla-community-news', 'http://www.joomla.org/index.php?option=com_rss_xtd&feed=RSS2.0&type=com_content&task=blogcategory&id=0&Itemid=33', '', '1', '5', '3600', '0', '0000-00-00 00:00:00', '9', '0'), ('6', '3', 'Linux hoy', 'linux-today', 'http://linuxtoday.com/backend/my-netscape.rdf', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '1', '0'), ('5', '4', 'Noticias de negocios', 'business-news', 'http://headlines.internet.com/internetnews/bus-news/news.rss', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '2', '0'), ('7', '5', 'Noticias de desarrolladores', 'web-developer-news', 'http://headlines.internet.com/internetnews/wd-news/news.rss', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '3', '0'), ('6', '6', 'Linux Central:Nuevos productos', 'linux-central-news-products', 'http://linuxcentral.com/backend/lcnew.rdf', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '4', '0'), ('6', '7', 'Linux Central:Los mejores', 'linux-central-best-selling', 'http://linuxcentral.com/backend/lcbestns.rdf', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '5', '0'), ('6', '8', 'Linux Central:Especiales', 'linux-central-daily-specials', 'http://linuxcentral.com/backend/lcspecialns.rdf', '', '1', '3', '3600', '0', '0000-00-00 00:00:00', '6', '0'), ('34', '9', 'Portal Joomla! Spanish', 'portal-joomla-spanish', 'http://www.joomlaspanish.org/component/option,com_rss/feed,RSS2.0/no_html,1/', NULL, '1', '5', '3600', '0', '0000-00-00 00:00:00', '1', '0'), ('34', '10', 'Centro de Extensiones Joomla! Spanish', 'centro-de-extensiones-joomla-spanish', 'http://extensiones.joomlaspanish.org/index.php?option=com_remository&Itemid=27&func=rss&no_html=1', NULL, '1', '15', '3600', '0', '0000-00-00 00:00:00', '2', '0');
CREATE TABLE `#__plugins` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(100) NOT NULL DEFAULT '',   `element` varchar(100) NOT NULL DEFAULT '',   `folder` varchar(100) NOT NULL DEFAULT '',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `published` tinyint(3) NOT NULL DEFAULT '0',   `iscore` tinyint(3) NOT NULL DEFAULT '0',   `client_id` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `params` text NOT NULL,   PRIMARY KEY (`id`),   KEY `idx_folder` (`published`,`client_id`,`access`,`folder`) ) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;
INSERT INTO `#__plugins` VALUES ('1', 'Autenticación - Joomla', 'joomla', 'authentication', '0', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', ''), ('2', 'Autenticación - LDAP', 'ldap', 'authentication', '0', '2', '0', '1', '0', '0', '0000-00-00 00:00:00', 'host=\nport=389\nuse_ldapV3=0\nnegotiate_tls=0\nno_referrals=0\nauth_method=bind\nbase_dn=\nsearch_string=\nusers_dn=\nusername=\npassword=\nldap_fullname=fullName\nldap_email=mail\nldap_uid=uid\n\n'), ('3', 'Autenticación - GMail', 'gmail', 'authentication', '0', '4', '0', '0', '0', '0', '0000-00-00 00:00:00', ''), ('4', 'Autenticación - OpenID', 'openid', 'authentication', '0', '3', '0', '0', '0', '0', '0000-00-00 00:00:00', ''), ('5', 'Usuario - Joomla!', 'joomla', 'user', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', 'autoregister=1\n\n'), ('6', 'Buscar - Contenido', 'content', 'search', '0', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\nsearch_content=1\nsearch_uncategorised=1\nsearch_archived=1\n\n'), ('7', 'Buscar - Contactos', 'contacts', 'search', '0', '3', '1', '1', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\n\n'), ('8', 'Buscar - Categorías', 'categories', 'search', '0', '4', '1', '0', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\n\n'), ('9', 'Buscar - Secciones', 'sections', 'search', '0', '5', '1', '0', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\n\n'), ('10', 'Buscar - Newsfeeds', 'newsfeeds', 'search', '0', '6', '1', '0', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\n\n'), ('11', 'Buscar - Weblinks', 'weblinks', 'search', '0', '2', '1', '1', '0', '0', '0000-00-00 00:00:00', 'search_limit=50\n\n'), ('12', 'Contenido - Pagebreak', 'pagebreak', 'content', '0', '10000', '1', '1', '0', '0', '0000-00-00 00:00:00', 'enabled=1\ntitle=1\nmultipage_toc=1\nshowall=1\n\n'), ('13', 'Contenido - Votar', 'vote', 'content', '0', '4', '1', '1', '0', '0', '0000-00-00 00:00:00', ''), ('14', 'Contenido - Email Cloaking', 'emailcloak', 'content', '0', '5', '1', '0', '0', '0', '0000-00-00 00:00:00', 'mode=1\n\n'), ('15', 'Contenido - Code Hightlighter (GeSHi)', 'geshi', 'content', '0', '5', '0', '0', '0', '0', '0000-00-00 00:00:00', ''), ('16', 'Contenido - Cargar módulo', 'loadmodule', 'content', '0', '6', '1', '0', '0', '0', '0000-00-00 00:00:00', 'enabled=1\nstyle=0\n\n'), ('17', 'Contenido - Page Navigation', 'pagenavigation', 'content', '0', '2', '1', '1', '0', '0', '0000-00-00 00:00:00', 'position=1\n\n'), ('18', 'Editor - No Editor', 'none', 'editors', '0', '0', '1', '1', '0', '0', '0000-00-00 00:00:00', ''), ('19', 'Editor - TinyMCE', 'tinymce', 'editors', '0', '0', '1', '1', '0', '0', '0000-00-00 00:00:00', 'mode=extended\nskin=0\ncompressed=0\ncleanup_startup=0\ncleanup_save=2\nentity_encoding=raw\nlang_mode=0\nlang_code=es\ntext_direction=ltr\ncontent_css=1\ncontent_css_custom=\nrelative_urls=1\nnewlines=0\ninvalid_elements=applet\nextended_elements=\ntoolbar=top\ntoolbar_align=left\nhtml_height=550\nhtml_width=750\nelement_path=1\nfonts=1\npaste=1\nsearchreplace=1\ninsertdate=1\nformat_date=%Y-%m-%d\ninserttime=1\nformat_time=%H:%M:%S\ncolors=1\ntable=1\nsmilies=1\nmedia=1\nhr=1\ndirectionality=1\nfullscreen=1\nstyle=1\nlayer=1\nxhtmlxtras=0\nvisualchars=1\nnonbreaking=1\nblockquote=1\ntemplate=0\nadvimage=1\nadvlink=1\nautosave=0\ncontextmenu=1\ninlinepopups=1\nsafari=0\ncustom_plugin=\ncustom_button=\n\n'), ('20', 'Editor - XStandard Lite 2.0', 'xstandard', 'editors', '0', '0', '1', '1', '0', '0', '0000-00-00 00:00:00', ''), ('21', 'Editor Botón - Imagen', 'image', 'editors-xtd', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('22', 'Editor Botón - Pagebreak', 'pagebreak', 'editors-xtd', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('23', 'Editor Botón - Leer más', 'readmore', 'editors-xtd', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('24', 'XML-RPC - Joomla', 'joomla', 'xmlrpc', '0', '7', '0', '1', '0', '0', '0000-00-00 00:00:00', ''), ('25', 'XML-RPC - Blogger API', 'blogger', 'xmlrpc', '0', '7', '0', '1', '0', '0', '0000-00-00 00:00:00', 'catid=1\nsectionid=0\n\n'), ('27', 'Sistema - SEF', 'sef', 'system', '0', '1', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('28', 'Sistema - Debug', 'debug', 'system', '0', '2', '1', '0', '0', '0', '0000-00-00 00:00:00', 'queries=1\nmemory=1\nlangauge=1\n\n'), ('29', 'Sistema - Legado', 'legacy', 'system', '0', '3', '0', '1', '0', '0', '0000-00-00 00:00:00', 'route=0\n\n'), ('30', 'Sistema - Cache', 'cache', 'system', '0', '4', '0', '1', '0', '0', '0000-00-00 00:00:00', 'browsercache=0\ncachetime=15\n\n'), ('31', 'Sistema - Log', 'log', 'system', '0', '5', '0', '1', '0', '0', '0000-00-00 00:00:00', ''), ('32', 'Sistema - Recordarme', 'remember', 'system', '0', '6', '1', '1', '0', '0', '0000-00-00 00:00:00', ''), ('33', 'Sistema - Backlink', 'backlink', 'system', '0', '7', '0', '1', '0', '0', '0000-00-00 00:00:00', ''), ('34', 'System - Mootools Upgrade', 'mtupgrade', 'system', '0', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', ''), ('35', 'Content - Ustream', 'bot_ustream', 'content', '0', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', 'fullscreen=yes\nmpwidth=416\nmpheight=340\nalignment=left\nmargin=0 10 10 0\npoptext=Open in popup window\npopshow=no\nautoplay=yes\nuscwidth=563\nuscheight=266\nchatalignment=left\nuscmargin=0 10 10 0\ndftchatsvr=chat1.ustream.tv\n'), ('36', 'System - System Restore Points', 'srp', 'system', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('37', 'System - One Click Action', 'oneclickaction', 'system', '0', '-31000', '1', '0', '0', '0', '0000-00-00 00:00:00', ''), ('38', 'System - Akeeba Backup Update Check', 'akeebaupdatecheck', 'system', '0', '0', '1', '0', '0', '0', '0000-00-00 00:00:00', '');
CREATE TABLE `#__poll_data` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `pollid` int(11) NOT NULL DEFAULT '0',   `text` text NOT NULL,   `hits` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `pollid` (`pollid`,`text`(1)) ) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
INSERT INTO `#__poll_data` VALUES ('1', '14', 'Comunidades-Grupos', '2'), ('2', '14', 'Sitios públicos', '3'), ('3', '14', 'Comercio electrónico', '1'), ('4', '14', 'Blogs', '0'), ('5', '14', 'Intranets', '0'), ('6', '14', 'Fotos y sitios multimedia', '2'), ('7', '14', 'Para todo lo anterior!', '3'), ('8', '14', '', '0'), ('9', '14', '', '0'), ('10', '14', '', '0'), ('11', '14', '', '0'), ('12', '14', '', '0');
CREATE TABLE `#__poll_date` (   `id` bigint(20) NOT NULL AUTO_INCREMENT,   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `vote_id` int(11) NOT NULL DEFAULT '0',   `poll_id` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `poll_id` (`poll_id`) ) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
INSERT INTO `#__poll_date` VALUES ('1', '2006-10-09 13:01:58', '1', '14'), ('2', '2006-10-10 15:19:43', '7', '14'), ('3', '2006-10-11 11:08:16', '7', '14'), ('4', '2006-10-11 15:02:26', '2', '14'), ('5', '2006-10-11 15:43:03', '7', '14'), ('6', '2006-10-11 15:43:38', '7', '14'), ('7', '2006-10-12 00:51:13', '2', '14'), ('8', '2007-05-10 19:12:29', '3', '14'), ('9', '2007-05-14 14:18:00', '6', '14'), ('10', '2007-06-10 15:20:29', '6', '14'), ('11', '2007-07-03 12:37:53', '2', '14');
CREATE TABLE `#__poll_menu` (   `pollid` int(11) NOT NULL DEFAULT '0',   `menuid` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`pollid`,`menuid`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__polls` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `voters` int(9) NOT NULL DEFAULT '0',   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `published` tinyint(1) NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '0',   `lag` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`) ) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
INSERT INTO `#__polls` VALUES ('14', '¿Para qué usas Joomla!?', 'joomla-is-used-for', '11', '0', '0000-00-00 00:00:00', '1', '0', '86400');
CREATE TABLE `#__sections` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL DEFAULT '',   `name` varchar(255) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `image` text NOT NULL,   `scope` varchar(50) NOT NULL DEFAULT '',   `image_position` varchar(30) NOT NULL DEFAULT '',   `description` text NOT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `access` tinyint(3) unsigned NOT NULL DEFAULT '0',   `count` int(11) NOT NULL DEFAULT '0',   `params` text NOT NULL,   PRIMARY KEY (`id`),   KEY `idx_scope` (`scope`) ) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
INSERT INTO `#__sections` VALUES ('1', 'Noticias', '', 'news', 'articles.jpg', 'content', 'right', 'Selecciona un nuevo tema desde la lista de más abajo y luego un artículo a leer.', '1', '0', '0000-00-00 00:00:00', '3', '0', '2', '');
CREATE TABLE `#__session` (   `username` varchar(150) DEFAULT '',   `time` varchar(14) DEFAULT '',   `session_id` varchar(200) NOT NULL DEFAULT '0',   `guest` tinyint(4) DEFAULT '1',   `userid` int(11) DEFAULT '0',   `usertype` varchar(50) DEFAULT '',   `gid` tinyint(3) unsigned NOT NULL DEFAULT '0',   `client_id` tinyint(3) unsigned NOT NULL DEFAULT '0',   `data` longtext,   PRIMARY KEY (`session_id`(64)),   KEY `whosonline` (`guest`,`usertype`),   KEY `userid` (`userid`),   KEY `time` (`time`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__stats_agents` (   `agent` varchar(255) NOT NULL DEFAULT '',   `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   `hits` int(11) unsigned NOT NULL DEFAULT '1' ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `#__templates_menu` (   `template` varchar(255) NOT NULL DEFAULT '',   `menuid` int(11) NOT NULL DEFAULT '0',   `client_id` tinyint(4) NOT NULL DEFAULT '0',   PRIMARY KEY (`menuid`,`client_id`,`template`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `#__templates_menu` VALUES ('fm_amiga', '0', '0'), ('khepri', '0', '1');
CREATE TABLE `#__users` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) NOT NULL DEFAULT '',   `username` varchar(150) NOT NULL DEFAULT '',   `email` varchar(100) NOT NULL DEFAULT '',   `password` varchar(100) NOT NULL DEFAULT '',   `usertype` varchar(25) NOT NULL DEFAULT '',   `block` tinyint(4) NOT NULL DEFAULT '0',   `sendEmail` tinyint(4) DEFAULT '0',   `gid` tinyint(3) unsigned NOT NULL DEFAULT '1',   `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `activation` varchar(100) NOT NULL DEFAULT '',   `params` text NOT NULL,   PRIMARY KEY (`id`),   KEY `usertype` (`usertype`),   KEY `idx_name` (`name`),   KEY `gid_block` (`gid`,`block`),   KEY `username` (`username`),   KEY `email` (`email`) ) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8;
INSERT INTO `#__users` VALUES ('62', 'Administrator', 'admin', 'nicolasvenica@gmail.com', 'c0554fb5e17abd289906823bc46d7f9d:i3yOJGFwgj1J2sWrpMf7bOd2afH8eWWC', 'Super Administrator', '0', '1', '25', '2011-12-10 17:40:37', '2012-02-24 20:35:52', '', '');
CREATE TABLE `#__weblinks` (   `id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `catid` int(11) NOT NULL DEFAULT '0',   `sid` int(11) NOT NULL DEFAULT '0',   `title` varchar(250) NOT NULL DEFAULT '',   `alias` varchar(255) NOT NULL DEFAULT '',   `url` varchar(250) NOT NULL DEFAULT '',   `description` text NOT NULL,   `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(11) NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `archived` tinyint(1) NOT NULL DEFAULT '0',   `approved` tinyint(1) NOT NULL DEFAULT '1',   `params` text NOT NULL,   PRIMARY KEY (`id`),   KEY `catid` (`catid`,`published`,`archived`) ) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
INSERT INTO `#__weblinks` VALUES ('1', '2', '0', 'Joomla!', 'joomla', 'http://www.joomla.org', 'Joomla!', '2005-02-14 15:19:02', '3', '1', '0', '0000-00-00 00:00:00', '1', '0', '1', 'target=0'), ('2', '2', '0', 'php.net', 'php', 'http://www.php.net', 'El lenguaje de programación en el que está escrito Joomla!', '2004-07-07 11:33:24', '6', '1', '0', '0000-00-00 00:00:00', '3', '0', '1', ''), ('3', '2', '0', 'MySQL', 'mysql', 'http://www.mysql.com', 'La base de datos que usa Joomla!', '2004-07-07 10:18:31', '1', '1', '0', '0000-00-00 00:00:00', '5', '0', '1', ''), ('4', '2', '0', 'OpenSourceMatters', 'opensourcematters', 'http://www.opensourcematters.org', 'OSM', '2005-02-14 15:19:02', '11', '1', '0', '0000-00-00 00:00:00', '2', '0', '1', 'target=0'), ('5', '2', '0', 'Joomla! - Foros', 'joomla-forums', 'http://forum.joomla.org', 'Foros de Joomla!', '2005-02-14 15:19:02', '4', '1', '0', '0000-00-00 00:00:00', '4', '0', '1', 'target=0'), ('6', '2', '0', 'Ohloh Tracking de Joomla!', 'ohloh-tracking-of-joomla', 'http://www.ohloh.net/projects/20', 'Informes objetivos sobre el desarrollo de Joomla. Joomla! tiene algunos desarrolladores estrella.', '2007-07-19 09:28:31', '1', '1', '0', '0000-00-00 00:00:00', '6', '0', '1', 'target=0\n\n');
