<?php 
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

defined('_JEXEC') or die('Restricted access');

$baseurl = JURI::root();
$basesource = JPATH_SITE;
$db =&JFactory::getDBO();

$id = (int) JRequest::getInt( 'id' );
$query = 'SELECT * FROM #__jxtc_primetime_item WHERE published=1 AND id='.$id;
$db->setQuery( $query );
$item = $db->loadObject();
$imagefile = $basesource.DS.str_replace('/', DS, $item->image);

if (!file_exists($imagefile)) return;  // Nothing to do

$config =& JComponentHelper::getParams( 'com_jxtcprimetime' );
$thumbx = $config->get( 'thumbx',60 );
$thumby = $config->get( 'thumby',60 );
$thumbsource = $basesource.DS.$config->get( 'thumbsource','images' );
$info=pathinfo($imagefile);
$imagename = $info['filename'];
$imageextension = $info['extension'];
$thumbfile = $thumbsource.DS.'th_'.$imagename.'_'.$thumbx.'x'.$thumby.'.'.$imageextension;

// Send existing thumbnail and return
if (file_exists($thumbfile)) {
	$doc =& JFactory::getDocument();
	switch(strtolower($imageextension)) {	// Set correct header
		case "gif":
		$doc->setMimeEncoding('image/gif');
		break;
		case "jpg":
		case "jpeg":
		$doc->setMimeEncoding('image/jpeg');
		break;
		case "png":
		$doc->setMimeEncoding('image/png');
		break;
	}
	readfile($thumbfile);	// Dump file contents
	return;
}

// Build thumbnail
switch($imageextension) {
	case "gif":
		if( function_exists("imagecreatefromgif") ) {
			$orig_img = imagecreatefromgif($imagefile);
			break;
		}
		else {
			echo 'Unsupported function: <b>imagecreatefromgif()</b>';
			exit;
			break;
		}
	case "jpg":
		$orig_img = imagecreatefromjpeg($imagefile);
		break;
	case "png":
		$orig_img = imagecreatefrompng($imagefile);
		break;
}

// Compute new size
$orig_size = getimagesize($imagefile);
$maxX = $thumbx;
$maxY = $thumby;
$newxsize = $maxX;
$newysize = $maxY;
if (($orig_size[0]*$maxY)<($orig_size[1]*$maxX)) {
	$newxsize = $newysize * ($orig_size[0]/$orig_size[1]);
	$adjustX = ($maxX - $newxsize)/2;
	$adjustY = 0;
}
else {
	$newysize = $newxsize / ($orig_size[0]/$orig_size[1]);
	$adjustX = 0;
	$adjustY = ($maxY - $newysize)/2;
}
		
if( function_exists("imagecreatetruecolor") ) {
  $new_img = imagecreatetruecolor($maxX,$maxY);
}
else {
  $new_img = imagecreate($maxX,$maxY);
}

$bgfill = imagecolorallocate( $new_img, 255, 255, 255 );

if( function_exists( "imageAntiAlias" )) {
	imageAntiAlias($new_img,true);
}
imagealphablending($new_img, false);
if( function_exists( "imagesavealpha")) {
	imagesavealpha($new_img,true);
}
if( function_exists( "imagecolorallocatealpha")) {
	$transparent = imagecolorallocatealpha($new_img, 255, 255, 255, 127);
}
			
//imagefill( $new_img, 0,0, $bgfill );
imagefill( $new_img, 0,0, $transparent );
if( function_exists("imagecopyresampled") ){
	ImageCopyResampled($new_img, $orig_img, $adjustX, $adjustY, 0, 0, $newxsize, $newysize,$orig_size[0], $orig_size[1]);
}
else {
	ImageCopyResized($new_img, $orig_img, $adjustX, $adjustY, 0, 0, $newxsize, $newysize,$orig_size[0], $orig_size[1]);
}

// Save image
$doc =& JFactory::getDocument();
switch($imageextension) {
	case "gif":
	imagegif($new_img,$thumbfile);
	$doc->setMimeEncoding('image/gif');
	imagegif($new_img);
	break;
	case "jpg":
	case "jpeg":
	imagejpeg($new_img, $thumbfile, 75);
	$doc->setMimeEncoding('image/jpeg');
	imagejpeg($new_img);
	break;
	case "png":
	imagepng($new_img,$thumbfile);
	$doc->setMimeEncoding('image/png');
	imagepng($new_img);
	break;
}
?>