<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

if (!defined('_JEXEC')) die('Direct Access to this location is not allowed.');

$slideshow = JRequest::getInt('id');
settype($slideshow, "integer"); 

if (empty($slideshow)) {
	return;
}

$db =&JFactory::getDBO();
$query = "SELECT * FROM #__jxtc_primetime WHERE published=1 AND id='$slideshow'";
$db->setQuery( $query );
$slideshow = $db->loadObject();

if (empty($slideshow)) {
//	echo JText::_('No default slideshow found.');
	return;
}

$query = 'SELECT * FROM #__jxtc_primetime_item WHERE published=1 AND slideshow_id='.$slideshow->id.' ORDER BY ordering';
$db->setQuery( $query );
$items = $db->loadObjectList();

if (empty($items)) return;	// Nothing to show

// Get Parameters
$textalign='';
switch ($slideshow->textAlign) {
	case 'r':
		$textalign = 'right';
	break;
	case 'c':
		$textalign = 'center';
	break;
	default: // 'l'
		$textalign = 'left';
	break;
}
$rotatingWheel = $slideshow->rotatingWheel == '1' ? 'true' : 'false' ;
$flyingSparkles = $slideshow->flyingSparkles == '1' ? 'true' : 'false' ;
$showThumbs = $slideshow->showThumbs == '1' ? 'true' : 'false' ;

$fvXML_prop  = '<prop>';
$fvXML_prop .= "<props image_duration='$slideshow->imageDuration'/>";
$fvXML_prop .= "<props text_color='0x$slideshow->textColor'/>";
$fvXML_prop .= "<props text_size='$slideshow->textSize'/>";
$fvXML_prop .= "<props text_align='$textalign'/>";
$fvXML_prop .= "<props rotating_wheel_effect='$rotatingWheel'/>";
$fvXML_prop .= "<props flying_sparkles_effect='$flyingSparkles'/>";

if ($showThumbs == 'true') {
	$fvXML_prop .= "<props showThumbs='true' ";
	$fvXML_prop .= "thumbWidth='$slideshow->thumbWidth' ";
	$fvXML_prop .= "thumbHeight='$slideshow->thumbHeight' ";
	$fvXML_prop .= "thumbGap='$slideshow->thumbGap' ";
	$fvXML_prop .= "bgColor='0x$slideshow->bgColor' ";
	$fvXML_prop .= "bgAlpha='$slideshow->bgAlpha' ";
	$fvXML_prop .= "borderColor='0x$slideshow->borderColor' ";
	$fvXML_prop .= "borderHighlite='0x$slideshow->borderHighlite' ";
	$fvXML_prop .= "borderSize='$slideshow->borderSize' />";
}
else {
	$fvXML_prop .= "<props showThumbs='false' />";
}

$fvXML_prop .= '</prop>';

$fvXML_images = '<images>';

foreach ($items as $item) {
	$file = urlencode($live_site.$item->image);
	if (empty($item->thumbnail)) {
		$thumb = urlencode($live_site.'index.php?option=com_jxtcprimetime&task=thumbnail&format=raw&id='.$item->id);
	}
	else {
		$thumb = urlencode($live_site.$item->thumbnail);
	}
	$item->text = urlencode($item->text);
	$item->url = urlencode($item->url);

	$fvXML_images .= "<image file='$file' thumb='$thumb' trans='$item->trans' transtime='$item->transtime' text='$item->text' url='$item->url' window='$item->target' />";
}

$fvXML_images .= '</images>';

$doc =&JFactory::getDocument();
$doc->setMimeEncoding('text/xml');
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
echo $fvXML_images.$fvXML_prop;
