<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class SlideshowViewSlideshow extends JView
{
	function display($tpl = null)
	{
		global $mainframe;

		$db		=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid 	= JRequest::getVar( 'cid', array(0), '', 'array' );
		$option = JRequest::getCmd( 'option');
		$uid 	= (int) @$cid[0];
		$edit=JRequest::getVar( 'edit', true );

		$row =& JTable::getInstance('slideshow', 'Table');
		// load the row from the db table
		if ($edit) {
			$row->load( $uid );
			// fail if checked out not by 'me'
			if ($row->isCheckedOut( $user->get('id') )) {
				$msg = JText::sprintf( 'DESCBEINGEDITTED', JText::_( 'The slideshow' ), $row->title );
				$this->setRedirect( 'index.php?option='. $option, $msg );
			}
			$row->checkout( $user->get('id') );
		}
		else {
			$row->published	= 1;
			$row->width	= 400;
			$row->height	= 300;
			$row->imageDuration= 10;
			$row->showThumbs = '1';
			$row->thumbWidth = 45;
			$row->thumbHeight = 35;
			$row->thumbGap = 5;
			$row->bgColor = '000000';
			$row->bgAlpha = 65;
			$row->borderColor = '474747';
			$row->borderHighlite = 'a9a9a9';
			$row->borderSize = 1;
		}
		
		// Build menu_position Selector
		$select = array(
					  JHTML::_('select.option', 'l', JText::_('Left') ),
					  JHTML::_('select.option', 'c', JText::_('Center') ),
					  JHTML::_('select.option', 'r', JText::_('Right') )
						);
		$textAlignSelector = JHTML::_('select.genericlist', 
                             $select, 
                             'textAlign', 
                             'class="inputbox"', 
                             'value', 
                             'text',
                             $row->textAlign);
		$this->assignRef('textAlignSelector',$textAlignSelector);

		$rotatingWheelSelector = JHTML::_('select.booleanlist',  'rotatingWheel', '', $row->rotatingWheel );
		$this->assignRef('rotatingWheelSelector',$rotatingWheelSelector);

		$flyingSparklesSelector = JHTML::_('select.booleanlist',  'flyingSparkles', '', $row->flyingSparkles );
		$this->assignRef('flyingSparklesSelector',$flyingSparklesSelector);

		$showThumbsSelector = JHTML::_('select.booleanlist',  'showThumbs', '', $row->showThumbs );
		$this->assignRef('showThumbsSelector',$showThumbsSelector);

		$publishedSelector = JHTML::_('select.booleanlist',  'published', '', $row->published );
		$this->assignRef('publishedSelector',$publishedSelector);

		$this->assignRef('row',	$row);
		$this->assignRef('edit', $edit);

		parent::display($tpl);

	}
}