<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

defined('_JEXEC') or die('Restricted access');

	$text = ( $this->edit ? JText::_( 'Slideshow Edit' ) : JText::_( 'New Slideshow' ) );

	JToolBarHelper::title(  JText::_( 'JoomlaXTC Primetime Slideshow Pro' ).' <small>[ ' . $text.' ]</small>' );
//	JToolBarHelper::Preview('index.php?option=com_jxtcprimetime&controller=slideshow&cid[]='.$cid[0]);
	JToolBarHelper::save();
	JToolBarHelper::apply();
	if ($this->edit) {
		// for existing items the button is renamed `close`
		JToolBarHelper::cancel( 'cancel', 'Close' );
	} else {
		JToolBarHelper::cancel();
	}
//	JToolBarHelper::help( 'screen.slideshows.edit' );

JFilterOutput::objectHTMLSafe( $this->row, ENT_QUOTES );
JHTML::_('behavior.tooltip');
?>
<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}
		// do field validation
		if (form.title.value == "") {
			alert( "<?php echo JText::_( 'Slideshow must have a title', true ); ?>" );
		} else {
			submitform( pressbutton );
		}
	}
</script>
<form action="index.php" method="post" name="adminForm">
<div>
	<fieldset class="adminform">
	<legend><?php echo JText::_( 'Details' ); ?></legend>
	<table class="admintable">
		<tr>
			<td width="110" class="key">
				<span class="hasTip" 
				   title="Title::Slide show title.">
					<?php echo JText::_( 'Title' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="title" id="title" size="60" value="<?php echo $this->row->title; ?>" />
			</td>
		</tr>

		<tr>
			<td width="110" class="key">
				<span class="hasTip" 
				   title="Width::Width of the Slideshow player box (in pixels).">
					<?php echo JText::_( 'Width' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="width" id="width" size="10" value="<?php echo $this->row->width; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Height::Height of the Slideshow player box (in pixels).">
				<?php echo JText::_( 'Height' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="height" id="height" size="10" value="<?php echo $this->row->height; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Image Duration::The time an image will be visible to the user.">
					<?php echo JText::_( 'Image Duration' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="imageDuration" id="imageDuration" size="10" value="<?php echo $this->row->imageDuration; ?>" /> Seconds
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Text Color::Banner text color (format: RRGGBB) (click on the field to activate a Color Picker).">
					<?php echo JText::_( 'Text Color' ); ?>:
				</span>
			</td>
			<td>
				<?php $fieldname = 'textColor'; include 'colorpicker.php'; ?>
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Text Size::Banner text size (in pixels).">
					<?php echo JText::_( 'Text Size' ); ?>:
				</span>
			</td>
			<td>
				<?php if (empty($this->row->textSize)) $this->row->textSize = 12; ?>
 				<input class="inputbox" type="text" name="textSize" id="textSize" size="10" value="<?php echo $this->row->textSize; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Text Alignment::Banner text alignment.">
					<?php echo JText::_( 'Text Align' ); ?>:
				</span>
			</td>
			<td>
				<?php echo $this->textAlignSelector; ?>
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Rotating Wheel::Enable or disable the Rotating Wheel effect.">
					<?php echo JText::_( 'Rotating Wheel' ); ?>:
				</span>
			</td>
			<td>
				<?php echo $this->rotatingWheelSelector; ?>
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Flying Sparks::Enable or disable the flying sparks effect.">
					<?php echo JText::_( 'Flying Sparks' ); ?>:
				</span>
			</td>
			<td>
				<?php echo $this->flyingSparklesSelector; ?>
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Show Thumbnails::Enable or disable image selector with thumbnails.">
					<?php echo JText::_( 'Show Thumbnails' ); ?>:
				</span>
			</td>
			<td>
				<?php echo $this->showThumbsSelector; ?>
			</td>
		</tr>

		<tr>
			<td width="110" class="key">
				<span class="hasTip" 
				   title="Thumbnail Width::Width of each thumbnail image.">
					<?php echo JText::_( 'Thumbnail Width' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="thumbWidth" id="thumbWidth" size="10" value="<?php echo $this->row->thumbWidth; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Thumbnail Height::Height of each Thumbnail image.">
				<?php echo JText::_( 'Thumbnail Height' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="thumbHeight" id="thumbHeight" size="10" value="<?php echo $this->row->thumbHeight; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Thumbnail Gap::Gap between thumbnail images.">
				<?php echo JText::_( 'Thumbnail Gap' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="thumbGap" id="thumbGap" size="10" value="<?php echo $this->row->thumbGap; ?>" /> Pixels
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Thumbnail Alpha::Thumbnail image transparency level.">
				<?php echo JText::_( 'Thumbnail Alpha' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="bgAlpha" id="bgAlpha" size="10" value="<?php echo $this->row->bgAlpha; ?>" /> From 0 to 100
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Thumbnail Border Width::Width of border around thumbnail images.">
				<?php echo JText::_( 'Thumbnail Border Width' ); ?>:
				</span>
			</td>
			<td>
				<input class="inputbox" type="text" name="borderSize" id="borderSize" size="10" value="<?php echo $this->row->borderSize; ?>" /> pixels
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Thumbnail Background Color::Thumbnail image background color (click on the field to activate a Color Picker).">
					<?php echo JText::_( 'Thumbnail Background Color' ); ?>:
				</span>
			</td>
			<td>
				<?php $fieldname = 'bgColor'; include 'colorpicker.php'; ?>
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Thumbnail Border Color::Color of border around thumbnail image (click on the field to activate a Color Picker).">
					<?php echo JText::_( 'Thumbnail Border Color' ); ?>:
				</span>
			</td>
			<td>
				<?php $fieldname = 'borderColor'; include 'colorpicker.php'; ?>
			</td>
		</tr>

		<tr>
			<td width="120" class="key">
				<span class="hasTip" 
				   title="Thumbnail Border Highlight Color::Color of border highlite around thumbnail image (click on the field to activate a Color Picker).">
					<?php echo JText::_( 'Thumbnail Border Highlite Color' ); ?>:
				</span>
			</td>
			<td>
				<?php $fieldname = 'borderHighlite'; include 'colorpicker.php'; ?>
			</td>
		</tr>

		<tr>
			<td class="key">
				<span class="hasTip" 
				   title="Published::Allow or disallow this slideshow display.">
					<?php echo JText::_( 'Published' ); ?>:
				</span>
			</td>
			<td>
				<?php echo $this->publishedSelector; ?>
			</td>
		</tr>

	</table>
	</fieldset>
</div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="option" value="com_jxtcprimetime" />
	<input type="hidden" name="id" value="<?php echo $this->row->id; ?>" />
	<input type="hidden" name="home" value="<?php echo $this->row->home; ?>" />
	<input type="hidden" name="cid[]" value="<?php echo $this->row->id; ?>" />
	<input type="hidden" name="textfieldcheck" value="<?php echo $n; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
