<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class ItemViewItem extends JView
{
	function display($tpl = null)	{
		global $mainframe;

		$db		=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid 	= JRequest::getVar( 'cid', array(0), '', 'array' );
		$option = JRequest::getCmd( 'option');
		$uid 	= (int) @$cid[0];
		$edit=JRequest::getVar( 'edit', true );

		$row =& JTable::getInstance('slideshow_item', 'Table');
		// load the row from the db table
		if ($edit)	$row->load( $uid );

		// fail if checked out not by 'me'
		if ($row->isCheckedOut( $user->get('id') )) {
			$msg = JText::sprintf( 'DESCBEINGEDITTED', JText::_( 'The item' ), $row->title );
			$this->setRedirect( 'index.php?option='. $option, $msg );
		}

		if ($row->id == 0)
		{
			// defaults
			$row->published	= 1;
			$row->ordering	= 1;
		}

		// Checkout item
		if ($edit) {
			$row->checkout( $user->get('id') );
		}

		// Map for template
		$this->assignRef('item',	$row);

// Build Slideshow Selectors
		$query = 'SELECT id as value, title as text FROM #__jxtc_primetime ORDER BY id';
		$db->setQuery($query);
		$slideshows = $db->loadObjectList('value');
		$slideshows = JHTML::_('select.genericlist', 
                             $slideshows, 
                             'slideshow_id', 
                             'class="inputbox"', 
                             'value', 
                             'text',
                             $row->slideshow_id);
		$this->assignRef('slideshows',	$slideshows);

		$select = array(
					  JHTML::_('select.option', '1' ),
					  JHTML::_('select.option', '2' ),
					  JHTML::_('select.option', '3' ),
					  JHTML::_('select.option', '4' ),
					  JHTML::_('select.option', '5' ),
					  JHTML::_('select.option', '6' ),
					  JHTML::_('select.option', '7' )
						);
		$transSelector = JHTML::_('select.genericlist', 
                             $select, 
                             'trans', 
                             'class="inputbox"', 
                             'value', 
                             'text',
                             $row->trans);
		$this->assignRef('transSelector',$transSelector);

		$select = array(
					  JHTML::_('select.option', '_top', '_top' ),
					  JHTML::_('select.option', '_blank', '_blank' ),
					  JHTML::_('select.option', '_parent', '_parent' ),
					  JHTML::_('select.option', '_self', '_self' )
						);
		$targetSelector = JHTML::_('select.genericlist', 
                             $select, 
                             'target', 
                             'class="inputbox"', 
                             'value', 
                             'text',
                             $row->target);
		$this->assignRef('targetSelector',$targetSelector);

		$publishedSelector = JHTML::_('select.booleanlist',  'published', '', $row->published );
		$this->assignRef('publishedSelector',$publishedSelector);

		parent::display($tpl);

	}
}