<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/
defined('_JEXEC') or die( 'Restricted access' );

class TableSlideshow extends JTable
{
	var $id					= 0;
	var $title				= '';
	var $width				= 0;
	var $height				= 0;
	var $imageDuration		= 0;
	var $textColor	= '';
	var $textSize			= 0;
	var $textAlign				= '';
	var $rotatingWheel		= '';
	var $flyingSparkles		= '';
	var $showThumbs = '';
	var $thumbWidth = 0;
	var $thumbHeight = 0;
	var $thumbGap = 0;
	var $bgColor = '';
	var $bgAlpha = 0;
	var $borderColor = '';
	var $borderHighlite = '';
	var $borderSize = 0;
	var $published			= 0;
	var $checked_out			= 0;
	var $checked_out_time	= '';
	var $home			= 0;

	function __construct( &$db )
	{
		parent::__construct( '#__jxtc_primetime', 'id', $db );
	}

	function bind( $array, $ignore='' )
	{
		$result = parent::bind( $array );
		// cast properties
		$this->id	= (int) $this->id;

		return $result;
	}

	function check()
	{
		// check for valid name
		if (trim( $this->title ) == '')
		{
			$this->setError(JText::_( 'Your Slideshow must contain a title.' ));
			return false;
		}
		// check for valid width
		$this->width = intval( $this->width );
		if ($this->width == 0) {
			$this->setError(JText::_( 'Your Slideshow must have a non-zero width.' ));
			return false;
		}

		// check for valid width
		$this->height = intval( $this->height );
		if ($this->height == 0) {
			$this->setError(JText::_( 'Your Slideshow must have a non-zero height.' ));
			return false;
		}

//		if(empty($this->alias)) {
//			$this->alias = $this->title;
//		}
//		$this->alias = JFilterOutput::stringURLSafe($this->alias);
//		if(trim(str_replace('-','',$this->alias)) == '') {
//			$datenow =& JFactory::getDate();
//			$this->alias = $datenow->toFormat("%Y-%m-%d-%H-%M-%S");
//		}

		return true;
	}

	// overloaded delete function
	function delete( $oid=null )
	{
		$k = $this->_tbl_key;
		if ( $oid ) {
			$this->$k = intval( $oid );
		}

		if ( parent::delete( $oid ))
		{
			$query = 'DELETE FROM #__jxtc_primetime_item'
			. ' WHERE id = '.(int) $this->$k
			;
			$this->_db->setQuery( $query );
			if ( !$this->_db->query() ) {
				$this->_error .= $this->_db->getErrorMsg() . "\n";
			}

			return true;
		}

		return false;
	}
}
