<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

$fieldName = 'upfile';

if (!isset($_FILES[$fieldName])) return;

//any errors the server registered on uploading
$fileError = $_FILES[$fieldName]['error'];
if ($fileError > 0) {
  switch ($fileError) 
  {
  case 1:
  echo JText::_( 'FILE TO LARGE THAN PHP INI ALLOWS' );
  return;

  case 2:
  echo JText::_( 'FILE TO LARGE THAN HTML FORM ALLOWS' );
  return;

  case 3:
  echo JText::_( 'ERROR PARTIAL UPLOAD' );
  return;

  case 4:
  echo JText::_( 'ERROR NO FILE' );
  return;
  }
}
 
//check for filesize
$fileSize = $_FILES[$fieldName]['size'];
//if($fileSize > 2000000)
//{
//    echo JText::_( 'FILE BIGGER THAN 2MB' );
//}
 
//check the file extension is ok
$fileName = $_FILES[$fieldName]['name'];
$uploadedFileNameParts = explode('.',$fileName);
$uploadedFileExtension = array_pop($uploadedFileNameParts);
 
$validFileExts = explode(',', 'jpeg,jpg,png,gif');
//assume the extension is false until we know its ok
$extOk = false;
 
//go through every ok extension, if the ok extension matches the file extension (case insensitive)
//then the file extension is ok
foreach($validFileExts as $key => $value) {
	if( preg_match("/$value/i", $uploadedFileExtension ) ) {
		$extOk = true;
	}
}
 
if ($extOk == false) {
	echo JText::_( 'INVALID EXTENSION' );
	return;
}
 
//the name of the file in PHP's temp directory that we are going to move to our folder
$fileTemp = $_FILES[$fieldName]['tmp_name'];
 
//for security purposes, we will also do a getimagesize on the temp file (before we have moved it 
//to the folder) to check the MIME type of the file, and whether it has a width and height
$imageinfo = getimagesize($fileTemp);
//we are going to define what file extensions/MIMEs are ok, and only let these ones in (whitelisting), rather than try to scan for bad
//types, where we might miss one (whitelisting is always better than blacklisting) 
$okMIMETypes = 'image/jpeg,image/pjpeg,image/png,imagex-png,image/gif';
$media_params = JComponentHelper::getParams( 'com_media' );
$upload_mime = $media_params->get( 'upload_mime' );
$validFileTypes = explode(",", $upload_mime);
//if the temp file does not have a width or a height, or it has a non ok MIME, return
if( !is_int($imageinfo[0]) || !is_int($imageinfo[1]) ||  !in_array($imageinfo['mime'], $validFileTypes) ) {
  echo JText::_( 'INVALID FILETYPE:'.$imageinfo['mime'] );
  return;
}
 
//lose any special characters in the filename
$fileName = ereg_replace("[^A-Za-z0-9.]", "-", $fileName);
 
//always use constants when making file paths, to avoid the possibilty of remote file inclusion
$uploadPath = $basePath.DS.$fileName;
if(!JFile::upload($fileTemp, $uploadPath)) {
  echo JText::_( 'ERROR MOVING FILE' );
  return;
}
?>