<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

defined('_JEXEC') or die( 'Restricted access' );

// Import Joomla! libraries
jimport('joomla.application.component.model');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

// Disable warnings because of open_basedir Warnings
ini_set( 'display_errors', 0 );

require_once( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_media'.DS.'helpers'.DS.'media.php' );

class SlideshowModelFiles extends JModel
{
    function getState($property = null)
    {
        static $set;

        $option = JRequest::getCmd( 'option' );
        $application = JFactory::getApplication();

//				// Get component parm
				$config =& JComponentHelper::getParams( 'com_jxtcprimetime' );
				$mediasource = $config->get( 'mediasource' );
//
//				// Check if source dir is changed
//        $olddefault = $application->getUserState( $option.'.olddefault',$mediasource );
//        echo "OLD [$olddefault] vs [$mediasource]";
//				if ($olddefault != $mediasource) {
//         	$set = 0;
//        }
//        $application->setUserState( $option.'.olddefault',$mediasource);

        if (!$set) {

						// Get fieldname
            $fieldname = $application->getUserStateFromRequest( $option.'.fieldname', 'fieldname', '' );
            $this->setState('fieldname', $fieldname);

            // current type
            $type = $application->getUserStateFromRequest( $option.'.type', 'type', '' );
            $this->setState('type', $type);

//            if( $type == 'link_file' ) {
//                $default_folder = 'images'.DS;
//            } else {
            $default_folder = $mediasource;
//            }

            // current folder
            $folder = $application->getUserStateFromRequest( $option.'.files.folder', 'folder', $default_folder );
            $folder = str_replace( DS.DS, DS, $folder );
            if( $folder == '.' ) $folder = '';
            if( $folder == DS ) $folder = '';
            if( $folder == 'undefined' ) $folder = '';
            if( $folder != '/' ) $folder = ereg_replace( '^/', '', $folder );
            $folder = str_replace( DS, '/', $folder );
            $this->setState('folder', $folder);

            // current item 
            $current = $application->getUserStateFromRequest( $option.'.files.current', 'current', '' );
            $this->setState('current', $current);

            // current base-path
            $basePath = JPATH_SITE.DS.$folder;
            $this->setState('basepath', $basePath);

            // current parent
            $parent = dirname($folder);
            if( $parent == '.' ) $parent = '/';
            if( $folder == '/' ) $parent = null;
            $this->setState('parent', $parent);

            $set = true;
        }
        return parent::getState($property);
    }

    function getFiles()
    {
        $list = $this->getList();
        return $list['files'];
    }

    function getFolders()
    {
        $list = $this->getList();
        return $list['folders'];
    }

    function getDocuments()
    {
        $list = $this->getList();
        return $list['docs'];
    }

    function getList()
    {
        static $list;

        // Only process the list once per request
        if (is_array($list)) {
            return $list;
        }

        // Initialize variables
        $basePath = $this->getState('basepath');
        $baseFolder = $this->getState('folder');
        $type = $this->getState('type');

        $files = array ();
        $folders = array ();
        $docs = array ();


				// Get upload files

				include 'getuploads.php';

        // Get the list of files and folders from the given folder
        if( is_readable( $basePath )) {
            $fileList = JFolder::files($basePath);
            $folderList = JFolder::folders($basePath);
        } else {
            $fileList = false;
            $folderList = false;
        }

        // Iterate over the files if they exist
        if ($fileList !== false) {
            foreach ($fileList as $file)
            {
                if (is_file($basePath.DS.$file) && substr($file, 0, 1) != '.' && strtolower($file) !== 'index.html') {
                    $tmp = new JObject();
                    $tmp->name = $file;
                    $tmp->path = JPath::clean($basePath.DS.$file);
                    $tmp->path_relative = $baseFolder.DS.basename($tmp->path);
                    $tmp->size = filesize($tmp->path);

                    $ext = strtolower(JFile::getExt($file));
                    switch ($ext)
                    {
                        // Image
                        case 'jpg':
                        case 'png':
                        case 'gif':
                        case 'xcf':
                        case 'odg':
                        case 'bmp':
                        case 'jpeg':
                            $info = @getimagesize($tmp->path);
                            $tmp->width = @$info[0];
                            $tmp->height = @$info[1];
                            $tmp->type = @$info[2];
                            $tmp->mime = @$info['mime'];

                            $msize = 60;
                            if (($info[0] > $msize) || ($info[1] > $msize)) {
                                $dimensions = MediaHelper::imageResize($info[0], $info[1], $msize);
                                $tmp->width = $dimensions[0];
                                $tmp->height = $dimensions[1];
                            }

                            $tmp->path = str_replace( DS, '/', $tmp->path );
                            $tmp->path_relative = str_replace( DS, '/', $tmp->path_relative );
                            $files[] = $tmp;
                            break;

                        // Non-image document
                        default:

//                            if( $type != 'link_file' ) {
//                                break;
//                            }

                            // First read the Media Manager parameters and check if this extension is allowed
                            $media_params = JComponentHelper::getParams( 'com_media' );
                            $allowable = explode( ',', $media_params->get( 'upload_extensions' ));
                            if( in_array( $ext, $allowable ) == false ) {
                                break;
                            }

                            $iconfile = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_media'.DS.'images'.DS.'mime-icon-32'.DS.$ext.'.png';
                            if (file_exists($iconfile)) {
                                $tmp->path_relative = 'administrator'.DS.'components'.DS.'com_media'.DS.'images'.DS.'mime-icon-32'.DS.$ext.'.png';
                            } else {
                                $tmp->path_relative = 'administrator'.DS.'components'.DS.'com_media'.DS.'images'.DS.'con_info.png';
                            }

                            $info = @getimagesize(JPATH_SITE.DS.$tmp->path_relative);
                            $tmp->width = @$info[0];
                            $tmp->height = @$info[1];

                            $tmp->path = str_replace( DS, '/', $tmp->path );
                            $tmp->path_relative = str_replace( DS, '/', $tmp->path_relative );
                            $files[] = $tmp;
                            break;
                    }
                }
            }
        }

        // Iterate over the folders if they exist
        if ($folderList !== false) {
            foreach ($folderList as $folder) {
    
                $tmp = new JObject();
                $tmp->name = basename($folder);
                $tmp->path = JPath::clean($basePath.DS.$folder);
                $tmp->path_relative = $tmp->name;
                $count = MediaHelper::countFiles($tmp->path);
                $tmp->files = $count[0];
                $tmp->folders = $count[1];

                $tmp->path = str_replace( DS, '/', $tmp->path );
                $tmp->path_relative = str_replace( DS, '/', $tmp->path_relative );

                $folders[] = $tmp;
            }
        }

        $list = array('folders' => $folders, 'docs' => $docs, 'files' => $files);

        return $list;
    }
}
?>