<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.2
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/

if (!defined('_JEXEC')) die('Direct Access to this location is not allowed.');

// Get installation defaults

$app =& JFactory::getApplication();
$dbprefix = $app->getCfg('dbprefix');

// Test for jxtc_primetime_item.transtime

$db =&JFactory::getDBO();

// Version 1.1
$table = $dbprefix."jxtc_primetime_item";
$result = $db->getTableFields( array($table) );

if (! isset($result[$table]['transtime'])) {
	$query = "ALTER TABLE `$table` ADD `transtime` FLOAT NOT NULL AFTER `trans`";
	$db->setQuery( $query );
	if (!$db->query()) { return JError::raiseError( 500, $db->getErrorMsg() ); }

	$query = "UPDATE `$table` SET `transtime` = 1";
	$db->setQuery( $query );
	if (!$db->query()) { return JError::raiseError( 500, $db->getErrorMsg() ); }

	echo "* Database has been upgraded to version 1.1";
}

// Version 1.2
$table = $dbprefix."jxtc_primetime";
$result = $db->getTableFields( array($table) );

if (! isset($result[$table]['showThumbs'])) {
	$query = "ALTER TABLE `$table` ADD `showThumbs` CHAR(1) NOT NULL AFTER `flyingSparkles`,";
	$query .= "ADD `thumbWidth` SMALLINT(3) NOT NULL AFTER `showThumbs`,";
	$query .= "ADD `thumbHeight` SMALLINT(3) NOT NULL AFTER `thumbWidth`,";
	$query .= "ADD `thumbGap` SMALLINT(3) NOT NULL AFTER `thumbHeight`,";
	$query .= "ADD `bgColor` CHAR(6) NOT NULL AFTER `thumbGap`,";
	$query .= "ADD `bgAlpha` SMALLINT(3) NOT NULL AFTER `bgColor`,";
	$query .= "ADD `borderColor` CHAR(6) NOT NULL AFTER `bgAlpha`,";
	$query .= "ADD `borderHighlite` CHAR(6) NOT NULL AFTER `borderColor`,";
	$query .= "ADD `borderSize` SMALLINT(2) NOT NULL AFTER `borderHighlite`";

	$db->setQuery( $query );
	if (!$db->query()) { return JError::raiseError( 500, $db->getErrorMsg() ); }

	$query = "UPDATE `$table` SET `showThumbs`=1,`thumbWidth`=45,`thumbHeight`=35,`thumbGap`=5,`bgColor`='000000',`bgAlpha`=65,`borderColor`='474747' ,`borderHighlite`='a9a9a9',`borderSize`=1";

	$db->setQuery( $query );
	if (!$db->query()) { return JError::raiseError( 500, $db->getErrorMsg() ); }

	echo "* Database has been upgraded to version 1.2";
}

?>