<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class SlideshowController extends JController
{
	function __construct( $default = array())
	{
		parent::__construct( $default );

		$this->registerTask( 'apply', 		'save');
		$this->registerTask( 'unpublish', 	'publish');
//		$this->registerTask( 'preview', 	'display');
		$this->registerTask( 'edit', 		'display');
		$this->registerTask( 'add' , 		'display' );

	}

	function display( )
	{
		switch($this->getTask())
		{
			case 'add'     :
			{
//				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
				JRequest::setVar( 'view', 'slideshow'  );
				JRequest::setVar( 'edit', false  );
			} break;
			case 'edit'    :
			{
//				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
				JRequest::setVar( 'view', 'slideshow'  );
				JRequest::setVar( 'edit', true  );
			} break;

			case 'preview' :
			{
				JRequest::setVar( 'tmpl', 'component' );
				JRequest::setVar( 'view', 'slideshow'  );
			} break;
		}

		//Set the default view, just in case
		$view = JRequest::getCmd('view');
		if(empty($view)) {
//			JRequest::setVar( 'hidemainmenu', 1 );
			JRequest::setVar('view', 'slideshows');
		};

		parent::display();
	}

	function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db		=& JFactory::getDBO();

		// save the slideshow parent information
		$row	=& JTable::getInstance('slideshow', 'Table');
		$post	= JRequest::get( 'post' );
		if (!$row->bind( $post ))
		{
			JError::raiseError(500, $row->getError() );
		}
		$isNew = ($row->id == 0);

		if (!$row->check())
		{
			JError::raiseError(500, $row->getError() );
		}

		if (!$row->store())
		{
			JError::raiseError(500, $row->getError() );
		}
		$row->checkin();
		// save the slideshow options
//		$items = JArrayHelper::getValue( $post, 'slideshowoption', array(), 'array' );
//
//		foreach ($items as $i=>$text)
//		{
//			$text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
//			if ($isNew)
//			{
//				$obj = new stdClass();
//				$obj->slideshowid = (int)$row->id;
//				$obj->text   = $text;
//				$db->insertObject('#__jxtc_primetime_item', $obj);
//			}
//			else
//			{
//				$obj = new stdClass();
//				$obj->id     = (int)$i;
//				$obj->text   = $text;
//				$db->updateObject('#__jxtc_primetime_item', $obj, 'id');
//			}
//		}

		switch ($this->_task)
		{
			case 'apply':
				$msg = JText::_( 'Changes to Slideshow saved' );
				$link = 'index.php?option=com_jxtcprimetime&view=slideshow&task=edit&cid[]='. $row->id .'';
				break;

			case 'save':
			default:
				$msg = JText::_( 'Slideshow saved' );
				$link = 'index.php?option=com_jxtcprimetime';
				break;
		}

		$this->setRedirect($link);
	}

	function remove()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db		=& JFactory::getDBO();
		$cid	= JRequest::getVar( 'cid', array(), '', 'array' );

		JArrayHelper::toInteger($cid);
		$msg = '';

		for ($i=0, $n=count($cid); $i < $n; $i++)
		{
			$slideshow =& JTable::getInstance('slideshow', 'Table');
			if (!$slideshow->delete( $cid[$i] ))
			{
				$msg .= $slideshow->getError();
			}
		}
		$this->setRedirect( 'index.php?option=com_jxtcprimetime', $msg );
	}

	function publish()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid		= JRequest::getVar( 'cid', array(), '', 'array' );
		$publish	= ( $this->getTask() == 'publish' ? 1 : 0 );

		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1)
		{
			$action = $publish ? 'publish' : 'unpublish';
			JError::raiseError(500, JText::_( 'Select an item to' .$action, true ) );
		}

		$cids = implode( ',', $cid );

		$query = 'UPDATE #__jxtc_primetime'
		. ' SET published = ' . (int) $publish
		. ' WHERE id IN ( '. $cids .' )'
		. ' AND ( checked_out = 0 OR ( checked_out = '.(int) $user->get('id').' ) )'
		;
		$db->setQuery( $query );
		if (!$db->query())
		{
			JError::raiseError(500, $db->getErrorMsg() );
		}

		if (count( $cid ) == 1)
		{
			$row =& JTable::getInstance('slideshow', 'Table');
			$row->checkin( $cid[0] );
		}
		$mainframe->redirect( 'index.php?option=com_jxtcprimetime' );
	}

	function cancel()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$id		= JRequest::getVar( 'id', 0, '', 'int' );
		$db		=& JFactory::getDBO();
		$row	=& JTable::getInstance('slideshow', 'Table');

		$row->checkin( $id );
		$this->setRedirect( 'index.php?option=com_jxtcprimetime' );
	}

	function setDefault()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid		= JRequest::getVar( 'cid', array(), '', 'array' );
		$default	= ( $this->getTask() == 'default' ? 1 : 0 );

		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1)
		{
			$action = $default ? 'default' : 'undefault';
			JError::raiseError(500, JText::_( 'Select an item to' .$action, true ) );
		}

		$id = $cid[0];

	// Disable all
		$query = 'UPDATE #__jxtc_primetime SET home = 0';
		$db->setQuery( $query );
		if (!$db->query())
		{
			JError::raiseError(500, $db->getErrorMsg() );
		}
	// enable one
		$query = 'UPDATE #__jxtc_primetime'
		. ' SET home = 1'
		. ' WHERE id = '. $id
		. ' AND ( checked_out = 0 OR ( checked_out = '.(int) $user->get('id').' ) )'
		;
		$db->setQuery( $query );
		if (!$db->query())
		{
			JError::raiseError(500, $db->getErrorMsg() );
		}

		if (count( $cid ) == 1)
		{
			$row =& JTable::getInstance('slideshow', 'Table');
			$row->checkin( $cid[0] );
		}
		$mainframe->redirect( 'index.php?option=com_jxtcprimetime' );
	}
}