<?php
/*
	JoomlaXTC Primetime Slideshow

	version 1.3
	
	Copyright (C) 2009  Monev Software LLC.	All Rights Reserved.
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.
	
	See COPYRIGHT.php for more information.
	See LICENSE.php for more information.
	
	Monev Software LLC
	www.joomlaxtc.com
*/
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class ItemController extends JController
{
	function __construct( $default = array())
	{
		parent::__construct( $default );

		$this->registerTask( 'apply', 		'save');
		$this->registerTask( 'unpublish', 	'publish');
//		$this->registerTask( 'preview', 	'display');
		$this->registerTask( 'edit', 		'display');
		$this->registerTask( 'add' , 		'display' );

	}

	function display( )
	{
		switch($this->getTask())
		{
			case 'add'     :
			{
//				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
				JRequest::setVar( 'view', 'item'  );
				JRequest::setVar( 'edit', false  );
			} break;
			case 'edit'    :
			{
//				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
				JRequest::setVar( 'view', 'item'  );
				JRequest::setVar( 'edit', true  );
			} break;

			case 'preview' :
			{
				JRequest::setVar( 'tmpl', 'component' );
				JRequest::setVar( 'view', 'item'  );
			} break;

			case 'orderup' :
				ItemController::orderItem(-1);
				break;
		
			case 'orderdown' :
				ItemController::orderItem(1);
				break;
		}

		//Set the default view, just in case
		$view = JRequest::getCmd('view');
		if(empty($view)) {
			JRequest::setVar('view', 'items');
		};

		parent::display();
	}

	function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db		=& JFactory::getDBO();

		// save the item parent information
		$row	=& JTable::getInstance('slideshow_item', 'Table');
//		$row->reorder();

		$post	= JRequest::get( 'post' );
		if (!$row->bind( $post ))
		{
			JError::raiseError(500, $row->getError() );
		}
		$isNew = ($row->id == 0);

		if (!$row->check())
		{
			JError::raiseError(500, $row->getError() );
		}

		if (!$row->store())
		{
			JError::raiseError(500, $row->getError() );
		}
		$row->checkin();
		// save the item options
//		$items = JArrayHelper::getValue( $post, 'itemoption', array(), 'array' );
//
//		foreach ($items as $i=>$text)
//		{
//			$text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
//			if ($isNew)
//			{
//				$obj = new stdClass();
//				$obj->itemid = (int)$row->id;
//				$obj->text   = $text;
//				$db->insertObject('#__jxtc_primetime_item', $obj);
//			}
//			else
//			{
//				$obj = new stdClass();
//				$obj->id     = (int)$i;
//				$obj->text   = $text;
//				$db->updateObject('#__jxtc_primetime_item', $obj, 'id');
//			}
//		}
//
		switch ($this->_task)
		{
			case 'apply':
				$msg = JText::_( 'Changes to Item saved' );
				$link = 'index.php?option=com_jxtcprimetime&view=item&c=item&task=edit&cid[]='. $row->id .'';
				break;

			case 'save':
			default:
				$msg = JText::_( 'Item saved' );
				$link = 'index.php?option=com_jxtcprimetime&c=item';
				break;
		}

		$this->setRedirect($link);
	}

	function remove()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db		=& JFactory::getDBO();
		$cid	= JRequest::getVar( 'cid', array(), '', 'array' );

		JArrayHelper::toInteger($cid);
		$msg = '';

		for ($i=0, $n=count($cid); $i < $n; $i++)
		{
			$item =& JTable::getInstance('slideshow_item', 'Table');
			if (!$item->delete( $cid[$i] ))
			{
				$msg .= $item->getError();
			}
		}
		$this->setRedirect( 'index.php?option=com_jxtcprimetime', $msg );
	}

	function publish()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid		= JRequest::getVar( 'cid', array(), '', 'array' );
		$publish	= ( $this->getTask() == 'publish' ? 1 : 0 );

		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1)
		{
			$action = $publish ? 'publish' : 'unpublish';
			JError::raiseError(500, JText::_( 'Select an item to' .$action, true ) );
		}

		$cids = implode( ',', $cid );

		$query = 'UPDATE #__jxtc_primetime_item'
		. ' SET published = ' . (int) $publish
		. ' WHERE id IN ( '. $cids .' )'
		. ' AND ( checked_out = 0 OR ( checked_out = '.(int) $user->get('id').' ) )'
		;
		$db->setQuery( $query );
		if (!$db->query())
		{
			JError::raiseError(500, $db->getErrorMsg() );
		}

		if (count( $cid ) == 1)
		{
			$row =& JTable::getInstance('slideshow_item', 'Table');
			$row->checkin( $cid[0] );
		}
		$mainframe->redirect( 'index.php?option=com_jxtcprimetime&c=item' );
	}

	function cancel()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$id		= JRequest::getVar( 'id', 0, '', 'int' );
		$db		=& JFactory::getDBO();
		$row	=& JTable::getInstance('slideshow_item', 'Table');

		$row->checkin( $id );
		$this->setRedirect( 'index.php?option=com_jxtcprimetime&c=item' );
	}

	function orderItem($direction)
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize variables
		$db		= & JFactory::getDBO();

		$cid	= JRequest::getVar( 'cid', array(), 'post', 'array' );

		if (isset( $cid[0] ))
		{
			$row = & JTable::getInstance('slideshow_item', 'Table');
			$row->load( (int) $cid[0] );
			$row->move($direction, 'id = ' . (int) $row->id);
		}
		$this->setRedirect('index.php?option=com_jxtcprimetime&c=item');
	}
}
?>